"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleTemplateTypeSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _role_template_type = require("../services/role_template_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/role_selector/role_template_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const templateTypeOptions = [{
  id: 'inline',
  label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleTemplate.inlineTypeLabel', {
    defaultMessage: 'Role template'
  })
}, {
  id: 'stored',
  label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleTemplate.storedTypeLabel', {
    defaultMessage: 'Stored script'
  })
}];
const RoleTemplateTypeSelect = props => {
  if (props.readOnly === undefined) props.readOnly = false;
  const availableOptions = templateTypeOptions.filter(({
    id
  }) => id === 'inline' && props.canUseInlineScripts || id === 'stored' && props.canUseStoredScripts);
  const selectedOptions = templateTypeOptions.filter(({
    id
  }) => id === 'inline' && (0, _role_template_type.isInlineRoleTemplate)(props.roleTemplate) || id === 'stored' && (0, _role_template_type.isStoredRoleTemplate)(props.roleTemplate));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: availableOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    "data-test-subj": "roleMappingsFormTemplateType",
    onChange: selected => {
      const [{
        id
      }] = selected;
      if (id === 'inline') {
        props.onChange({
          ...props.roleTemplate,
          template: {
            source: ''
          }
        });
      } else {
        props.onChange({
          ...props.roleTemplate,
          template: {
            id: ''
          }
        });
      }
    },
    isClearable: false,
    isDisabled: props.readOnly,
    "aria-label": _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleTemplate.typeComboBoxAriaLabel', {
      defaultMessage: 'Role template'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
exports.RoleTemplateTypeSelect = RoleTemplateTypeSelect;