"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.frequencyToFieldsMap = exports.frequencyToBaselineFieldsMap = exports.UNITS = exports.MONTH_OPTIONS = exports.MINUTE_OPTIONS = exports.HOUR_OPTIONS = exports.EVERY_MINUTE_OPTIONS = exports.DAY_OPTIONS = exports.DATE_OPTIONS = void 0;
var _lodash = require("lodash");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function makeSequence(min, max) {
  const values = [];
  for (let i = min; i <= max; i++) {
    values.push(i);
  }
  return values;
}
const EVERY_MINUTE_OPTIONS = exports.EVERY_MINUTE_OPTIONS = [{
  text: '5',
  value: '0,5,10,15,20,25,30,35,40,45,50,55'
}, {
  text: '10',
  value: '0,10,20,30,40,50'
}, {
  text: '15',
  value: '0,15,30,45'
}, {
  text: '30',
  value: '0,30'
}];
const MINUTE_OPTIONS = exports.MINUTE_OPTIONS = makeSequence(0, 59).map(value => ({
  value: value.toString(),
  text: (0, _lodash.padStart)(value.toString(), 2, '0')
}));
const HOUR_OPTIONS = exports.HOUR_OPTIONS = makeSequence(0, 23).map(value => ({
  value: value.toString(),
  text: (0, _lodash.padStart)(value.toString(), 2, '0')
}));
const DAY_OPTIONS = exports.DAY_OPTIONS = makeSequence(1, 7).map(value => ({
  value: value.toString(),
  text: (0, _services.getDayName)(value - 1)
}));
const DATE_OPTIONS = exports.DATE_OPTIONS = makeSequence(1, 31).map(value => ({
  value: value.toString(),
  text: (0, _services.getOrdinalValue)(value)
}));
const MONTH_OPTIONS = exports.MONTH_OPTIONS = makeSequence(1, 12).map(value => ({
  value: value.toString(),
  text: (0, _services.getMonthName)(value - 1)
}));
const UNITS = exports.UNITS = [{
  value: 'MINUTE',
  text: 'minute'
}, {
  value: 'HOUR',
  text: 'hour'
}, {
  value: 'DAY',
  text: 'day'
}, {
  value: 'WEEK',
  text: 'week'
}, {
  value: 'MONTH',
  text: 'month'
}, {
  value: 'YEAR',
  text: 'year'
}];
const frequencyToFieldsMap = exports.frequencyToFieldsMap = {
  MINUTE: {
    minute: true
  },
  HOUR: {
    minute: true
  },
  DAY: {
    hour: true,
    minute: true
  },
  WEEK: {
    day: true,
    hour: true,
    minute: true
  },
  MONTH: {
    date: true,
    hour: true,
    minute: true
  },
  YEAR: {
    month: true,
    date: true,
    hour: true,
    minute: true
  }
};
const frequencyToBaselineFieldsMap = exports.frequencyToBaselineFieldsMap = {
  MINUTE: {
    second: '0',
    minute: '0,5,10,15,20,25,30,35,40,45,50,55',
    hour: '*',
    date: '*',
    month: '*',
    day: '?'
  },
  HOUR: {
    second: '0',
    minute: '0',
    hour: '*',
    date: '*',
    month: '*',
    day: '?'
  },
  DAY: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '*',
    month: '*',
    day: '?'
  },
  WEEK: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '?',
    month: '*',
    day: '7'
  },
  MONTH: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '1',
    month: '*',
    day: '?'
  },
  YEAR: {
    second: '0',
    minute: '0',
    hour: '0',
    date: '1',
    month: '1',
    day: '?'
  }
};