"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerActions = void 0;
var _kibana_services = require("../kibana_services");
var _constants = require("./edit_panel_action/constants");
var _constants2 = require("./inspect_panel_action/constants");
var _constants3 = require("./remove_panel_action/constants");
var _constants4 = require("./customize_panel_action/constants");
var _triggers = require("./triggers");
var _constants5 = require("./show_config_panel_action/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const registerActions = () => {
  _kibana_services.uiActions.registerActionAsync(_constants3.ACTION_REMOVE_PANEL, async () => {
    const {
      RemovePanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../panel_component/panel_module')));
    return new RemovePanelAction();
  });
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, _constants3.ACTION_REMOVE_PANEL);
  _kibana_services.uiActions.registerActionAsync(_constants4.CUSTOM_TIME_RANGE_BADGE, async () => {
    const {
      CustomTimeRangeBadge
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../panel_component/panel_module')));
    return new CustomTimeRangeBadge();
  });
  _kibana_services.uiActions.attachAction(_triggers.PANEL_BADGE_TRIGGER, _constants4.CUSTOM_TIME_RANGE_BADGE);
  _kibana_services.uiActions.registerActionAsync(_constants2.ACTION_INSPECT_PANEL, async () => {
    const {
      InspectPanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../panel_component/panel_module')));
    return new InspectPanelAction();
  });
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, _constants2.ACTION_INSPECT_PANEL);
  _kibana_services.uiActions.registerActionAsync(_constants.ACTION_EDIT_PANEL, async () => {
    const {
      EditPanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../panel_component/panel_module')));
    return new EditPanelAction();
  });
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, _constants.ACTION_EDIT_PANEL);
  _kibana_services.uiActions.registerActionAsync(_constants4.ACTION_CUSTOMIZE_PANEL, async () => {
    const {
      CustomizePanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../panel_component/panel_module')));
    return new CustomizePanelAction();
  });
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, _constants4.ACTION_CUSTOMIZE_PANEL);
  _kibana_services.uiActions.registerActionAsync(_constants5.ACTION_SHOW_CONFIG_PANEL, async () => {
    const {
      ShowConfigPanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../panel_component/panel_module')));
    return new ShowConfigPanelAction();
  });
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, _constants5.ACTION_SHOW_CONFIG_PANEL);
};
exports.registerActions = registerActions;