"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsPolicyLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../common/lib/kibana");
var _use_agent_policy = require("./use_agent_policy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/agent_policies/agents_policy_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiLinkCss = {
  whiteSpace: 'nowrap',
  textOverflow: 'ellipsis',
  overflow: 'hidden'
};
const AgentsPolicyLinkComponent = ({
  policyId
}) => {
  var _data$name;
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const {
    data
  } = (0, _use_agent_policy.useAgentPolicy)({
    policyId
  });
  const href = (0, _react.useMemo)(() => getUrlForApp(_common.PLUGIN_ID, {
    path: _public.pagePathGetters.policy_details({
      policyId
    })[1]
  }), [getUrlForApp, policyId]);
  const handleClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      return navigateToApp(_common.PLUGIN_ID, {
        path: _public.pagePathGetters.policy_details({
          policyId
        })[1]
      });
    }
  }, [navigateToApp, policyId]);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      href: href,
      onClick: handleClick,
      css: euiLinkCss,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 5
      }
    }, (_data$name = data === null || data === void 0 ? void 0 : data.name) !== null && _data$name !== void 0 ? _data$name : policyId)
  );
};
const AgentsPolicyLink = exports.AgentsPolicyLink = /*#__PURE__*/_react.default.memo(AgentsPolicyLinkComponent);