"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _onechatCommon = require("@kbn/onechat-common");
var _tracing = require("../../tracing");
var _utils = require("./utils");
var _events = require("./utils/events");
var _resolve_selected_connector_id = require("./utils/resolve_selected_connector_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parameters for {@link ChatService.converse}
 */

const createChatService = options => {
  return new ChatServiceImpl(options);
};
exports.createChatService = createChatService;
class ChatServiceImpl {
  constructor({
    inference,
    logger,
    conversationService,
    agentService,
    uiSettings,
    savedObjects
  }) {
    (0, _defineProperty2.default)(this, "inference", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "conversationService", void 0);
    (0, _defineProperty2.default)(this, "agentService", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    this.inference = inference;
    this.logger = logger;
    this.conversationService = conversationService;
    this.agentService = agentService;
    this.uiSettings = uiSettings;
    this.savedObjects = savedObjects;
  }
  converse({
    agentId = _onechatCommon.oneChatDefaultAgentId,
    conversationId,
    connectorId,
    capabilities,
    request,
    abortSignal,
    nextInput,
    autoCreateConversationWithId = false
  }) {
    const {
      inference
    } = this;
    const isNewConversation = !conversationId;
    return (0, _tracing.withConverseSpan)({
      agentId,
      conversationId
    }, span => {
      return (0, _rxjs.defer)(() => (0, _resolve_selected_connector_id.resolveSelectedConnectorId)({
        uiSettings: this.uiSettings,
        savedObjects: this.savedObjects,
        request,
        connectorId,
        inference: this.inference
      })).pipe((0, _rxjs.switchMap)(selectedConnectorId => {
        if (!selectedConnectorId) {
          return (0, _rxjs.throwError)(() => new Error('No connector available for chat execution'));
        }
        return (0, _rxjs.forkJoin)({
          conversationClient: (0, _rxjs.defer)(async () => this.conversationService.getScopedClient({
            request
          })),
          agent: (0, _rxjs.defer)(async () => {
            const agentRegistry = await this.agentService.getRegistry({
              request
            });
            return agentRegistry.get(agentId);
          }),
          chatModel: (0, _utils.getChatModel$)({
            connectorId: selectedConnectorId,
            request,
            inference,
            span
          }),
          selectedConnectorId: (0, _rxjs.of)(selectedConnectorId)
        });
      }), (0, _rxjs.switchMap)(({
        conversationClient,
        chatModel,
        agent,
        selectedConnectorId
      }) => {
        const shouldCreateNewConversation$ = isNewConversation ? (0, _rxjs.of)(true) : autoCreateConversationWithId ? (0, _utils.conversationExists$)({
          conversationId,
          conversationClient
        }).pipe((0, _rxjs.switchMap)(exists => (0, _rxjs.of)(!exists))) : (0, _rxjs.of)(false);
        const conversation$ = (0, _utils.getConversation$)({
          agentId,
          conversationId,
          autoCreateConversationWithId,
          conversationClient
        });

        // Extract the ID from the conversation and emit the event ONLY for new conversations
        const conversationIdSetEvent$ = shouldCreateNewConversation$.pipe((0, _rxjs.switchMap)(shouldCreate => shouldCreate ? conversation$.pipe((0, _rxjs.map)(conversation => (0, _events.createConversationIdSetEvent)(conversation.id)), (0, _rxjs.take)(1)) : _rxjs.EMPTY));
        const agentEvents$ = (0, _utils.executeAgent$)({
          agentId,
          request,
          conversation$,
          nextInput,
          capabilities,
          abortSignal,
          agentService: this.agentService,
          defaultConnectorId: selectedConnectorId
        });
        const title$ = shouldCreateNewConversation$.pipe((0, _rxjs.switchMap)(shouldCreate => shouldCreate ? (0, _utils.generateTitle$)({
          chatModel,
          conversation$,
          nextInput
        }) : conversation$.pipe((0, _rxjs.switchMap)(conversation => {
          return (0, _rxjs.of)(conversation.title);
        }))));
        const roundCompletedEvents$ = agentEvents$.pipe((0, _rxjs.filter)(_onechatCommon.isRoundCompleteEvent));
        const saveOrUpdateAndEmit$ = shouldCreateNewConversation$.pipe((0, _rxjs.switchMap)(shouldCreate => shouldCreate ? conversation$.pipe((0, _rxjs.switchMap)(conversation => (0, _utils.createConversation$)({
          agentId,
          conversationClient,
          conversationId: conversationId || conversation.id,
          title$,
          roundCompletedEvents$
        }))) : (0, _utils.updateConversation$)({
          conversationClient,
          conversation$,
          title$,
          roundCompletedEvents$
        })));
        return (0, _rxjs.merge)(conversationIdSetEvent$, agentEvents$, saveOrUpdateAndEmit$).pipe((0, _utils.handleCancellation)(abortSignal), (0, _rxjs.catchError)(err => {
          this.logger.error(`Error executing agent: ${err.stack}`);
          return (0, _rxjs.throwError)(() => {
            const traceId = (0, _tracing.getCurrentTraceId)();
            if ((0, _onechatCommon.isOnechatError)(err)) {
              err.meta = {
                ...err.meta,
                traceId
              };
              return err;
            } else {
              return (0, _onechatCommon.createInternalError)(`Error executing agent: ${err.message}`, {
                statusCode: 500,
                traceId
              });
            }
          });
        }), (0, _rxjs.shareReplay)());
      }));
    });
  }
}