"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandSnippet = CommandSnippet;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _build_helm_command = require("./build_helm_command");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _pricing_features = require("../../../../common/pricing_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/kubernetes/command_snippet.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CommandSnippet({
  encodedApiKey,
  onboardingId,
  elasticsearchUrl,
  isCopyPrimaryAction,
  elasticAgentVersionInfo
}) {
  const metricsEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const command = (0, _build_helm_command.buildHelmCommand)({
    encodedApiKey,
    onboardingId,
    elasticsearchUrl,
    metricsEnabled,
    elasticAgentVersionInfo
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.kubernetesPanel.installElasticAgentDescription",
    defaultMessage: "Copy and run the install command. Note that the following manifest contains resource limits that may not be appropriate for a production environment, review our guide on {scalingLink} before deploying this manifest.",
    values: {
      scalingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityOnboardingKubernetesPanelScalingElasticAgentOnKubernetesLink",
        href: "https://www.elastic.co/guide/en/fleet/current/scaling-on-kubernetes.html",
        external: true,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.kubernetesPanel.scalingElasticAgentOnLinkLabel', {
        defaultMessage: 'Scaling Elastic Agent on Kubernetes'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "text",
    paddingSize: "m",
    fontSize: "m",
    "data-test-subj": "observabilityOnboardingKubernetesPanelCodeSnippet",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, command), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
    textToCopy: command,
    fill: isCopyPrimaryAction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }));
}