"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextFunctionRequestIfNeeded = getContextFunctionRequestIfNeeded;
var _lodash = require("lodash");
var _common = require("../../../common");
var _create_function_request_message = require("../../../common/utils/create_function_request_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getContextFunctionRequestIfNeeded(messages) {
  var _last, _last$message$functio;
  const indexOfLastUserMessage = (0, _lodash.findLastIndex)(messages, message => message.message.role === _common.MessageRole.User && !message.message.name);
  const hasContextSinceLastUserMessage = messages.slice(indexOfLastUserMessage).some(message => message.message.name === _common.CONTEXT_FUNCTION_NAME);
  const isLastMessageFunctionRequest = !!((_last = (0, _lodash.last)(messages)) !== null && _last !== void 0 && (_last$message$functio = _last.message.function_call) !== null && _last$message$functio !== void 0 && _last$message$functio.name);
  if (hasContextSinceLastUserMessage || isLastMessageFunctionRequest) {
    return undefined;
  }
  return (0, _create_function_request_message.createFunctionRequestMessage)({
    name: _common.CONTEXT_FUNCTION_NAME
  });
}