"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListingCallOut = ListingCallOut;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("./formatting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/setup_mode/listing_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MIGRATE_TO_MB_LABEL = _i18n.i18n.translate('xpack.monitoring.setupMode.migrateToMetricbeat', {
  defaultMessage: 'Monitor with Metricbeat'
});
function ListingCallOut({
  setupModeData,
  productName,
  customRenderer
}) {
  if (customRenderer) {
    const {
      shouldRender,
      componentToRender
    } = customRenderer();
    if (shouldRender) {
      return componentToRender;
    }
  }
  const mightExist = (0, _lodash.get)(setupModeData, 'detected.mightExist');
  const hasInstances = setupModeData.totalUniqueInstanceCount > 0;
  if (!hasInstances) {
    if (mightExist) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.monitoring.setupMode.detectedNodeTitle', {
          defaultMessage: '{product} {identifier} detected',
          values: {
            product: (0, _formatting.formatProductName)(productName),
            identifier: (0, _formatting.getIdentifier)(productName)
          }
        }),
        color: "warning",
        iconType: "flag",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.monitoring.setupMode.detectedNodeDescription', {
        defaultMessage: `Click 'Set up monitoring' below to start monitoring this {identifier}.`,
        values: {
          identifier: (0, _formatting.getIdentifier)(productName)
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.noMonitoringDataFound', {
        defaultMessage: 'No {product} {identifier} detected',
        values: {
          product: (0, _formatting.formatProductName)(productName),
          identifier: (0, _formatting.getIdentifier)(productName, true)
        }
      }),
      iconType: "flag",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.monitoring.setupMode.netNewUserDescription', {
      defaultMessage: `Click 'Set up monitoring' to start monitoring with Metricbeat.`
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }));
  }
  if (setupModeData.totalUniqueFullyMigratedCount === setupModeData.totalUniqueInstanceCount) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.metricbeatAllNodes', {
        defaultMessage: 'Metricbeat is monitoring all {identifier}.',
        values: {
          identifier: (0, _formatting.getIdentifier)(productName, true)
        }
      }),
      color: "success",
      iconType: "flag",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }));
  }
  if (setupModeData.totalUniquePartiallyMigratedCount === setupModeData.totalUniqueInstanceCount) {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.monitoring.setupMode.disableInternalCollectionTitle', {
        defaultMessage: 'Disable self monitoring'
      }),
      color: "warning",
      iconType: "flag",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.monitoring.setupMode.disableInternalCollectionDescription', {
      defaultMessage: `Metricbeat is now monitoring your {product} {identifier}. Disable self monitoring to finish the migration.`,
      values: {
        product: (0, _formatting.formatProductName)(productName),
        identifier: (0, _formatting.getIdentifier)(productName, true)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }));
  }
  if (setupModeData.totalUniqueInstanceCount > 0) {
    if (setupModeData.totalUniqueFullyMigratedCount === 0 && setupModeData.totalUniquePartiallyMigratedCount === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: MIGRATE_TO_MB_LABEL,
        color: "danger",
        iconType: "flag",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.monitoring.setupMode.migrateToMetricbeatDescription', {
        defaultMessage: `These {product} {identifier} are self monitored.
                Click 'Monitor with Metricbeat' to migrate.`,
        values: {
          product: (0, _formatting.formatProductName)(productName),
          identifier: (0, _formatting.getIdentifier)(productName, true)
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: MIGRATE_TO_MB_LABEL,
      color: "danger",
      iconType: "flag",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.monitoring.setupMode.migrateSomeToMetricbeatDescription', {
      defaultMessage: `Some {product} {identifier} are monitored through self monitoring. Migrate to monitor with Metricbeat.`,
      values: {
        product: (0, _formatting.formatProductName)(productName),
        identifier: (0, _formatting.getIdentifier)(productName, true)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 9
      }
    }));
  }
  return null;
}