"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmOverview = ApmOverview;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _apm_metrics = require("../apm_metrics");
var _status = require("./status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/apm/overview/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const title = _i18n.i18n.translate('xpack.monitoring.apm.overview.panels.title', {
  defaultMessage: 'APM Server - Metrics'
});
function ApmOverview(props) {
  const {
    metrics
  } = props;
  const seriesToShow = [metrics.apm_responses_valid, metrics.apm_responses_errors, metrics.apm_output_events_rate_success, metrics.apm_output_events_rate_failure, metrics.apm_requests, metrics.apm_transformations];
  const metricProps = {
    ...props,
    title,
    seriesToShow
  };
  return /*#__PURE__*/_react.default.createElement(_apm_metrics.ApmMetrics, (0, _extends2.default)({}, metricProps, {
    StatusComponent: _status.Status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 10
    }
  }));
}