"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyJobSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _anomaly_job_selector_empty_state = require("./anomaly_job_selector_empty_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/maps/anomaly_job_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AnomalyJobSelector extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "onJobIdSelect", selectedOptions => {
      const jobId = selectedOptions[0].value;
      if (this._isMounted) {
        this.setState({
          jobId
        });
        this.props.onJobChange(jobId);
      }
    });
  }
  async _loadJobs() {
    const jobIdList = await this.props.mlJobsService.jobIdsWithGeo();
    const options = jobIdList.map(jobId => {
      return {
        label: jobId,
        value: jobId
      };
    });
    if (this._isMounted && !(0, _lodash.isEqual)(options, this.state.jobIdList)) {
      this.setState({
        jobIdList: options
      });
    }
  }
  componentDidUpdate(prevProps, prevState) {
    this._loadJobs();
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadJobs();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    var _this$state$jobIdList, _this$state$jobIdList2;
    const supportedJobsExist = ((_this$state$jobIdList = this.state.jobIdList) === null || _this$state$jobIdList === void 0 ? void 0 : _this$state$jobIdList.length) && ((_this$state$jobIdList2 = this.state.jobIdList) === null || _this$state$jobIdList2 === void 0 ? void 0 : _this$state$jobIdList2.length) > 0;
    return supportedJobsExist || !this.props.jobsManagementPath ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.ml.maps.jobIdLabel', {
        defaultMessage: 'Job ID'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      singleSelection: true,
      onChange: this.onJobIdSelect,
      options: this.state.jobIdList,
      selectedOptions: this.state.jobId ? [{
        value: this.state.jobId,
        label: this.state.jobId
      }] : [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    })) : /*#__PURE__*/_react.default.createElement(_anomaly_job_selector_empty_state.AnomalyJobSelectorEmptyState, {
      jobsManagementPath: this.props.jobsManagementPath,
      canCreateJobs: this.props.canCreateJobs,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    });
  }
}
exports.AnomalyJobSelector = AnomalyJobSelector;