"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyTimelineHelpPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _help_popover = require("../components/help_popover/help_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/anomaly_timeline_help_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AnomalyTimelineHelpPopover = () => {
  return /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
    anchorPosition: "upCenter",
    title: _i18n.i18n.translate('xpack.ml.explorer.anomalyTimelinePopoverTitle', {
      defaultMessage: 'Anomaly timelines'
    }),
    buttonCss: (0, _react2.css)`
        color: inherit;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomalyTimelinePopoverBasicExplanation",
    defaultMessage: "Swim lanes provide an overview of the buckets of data that have been analyzed within the selected time period. You can view an overall swim lane or view them by job or influencer.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomalyTimelinePopoverScoreExplanation",
    defaultMessage: "Each block in a swim lane is colored according to its anomaly score, which is a value from 0 to 100. The blocks with high scores are shown in red and low scores are indicated in blue.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomalyTimelinePopoverAdvancedExplanation",
    defaultMessage: "The anomaly scores that you see in each section of the Anomaly Explorer might differ slightly. This disparity occurs because for each job there are bucket results, overall bucket results, influencer results, and record results. Anomaly scores are generated for each type of result. The overall swim lane shows the maximum overall bucket score for each block. When you view a swim lane by job, it shows the maximum bucket score in each block. When you view by influencer, it shows the maximum influencer score in each block.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomalyTimelinePopoverSelectionExplanation",
    defaultMessage: "When you select one or more blocks in the swim lanes, the list of anomalies and top influencers is likewise filtered to provide information relative to that selection.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  })));
};
exports.AnomalyTimelineHelpPopover = AnomalyTimelineHelpPopover;