"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsItems = exports.AnomalyExplanationDetails = void 0;
exports.getInfluencersItems = getInfluencersItems;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _entity_cell = require("../entity_cell");
var _format_value = require("../../formatters/format_value");
var _kibana = require("../../contexts/kibana");
var _anomaly_value_display = require("./anomaly_value_display");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/anomalies_table/anomaly_details_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TIME_FIELD_NAME = 'timestamp';
function getFilterEntity(entityName, entityValue, filter) {
  return /*#__PURE__*/_react.default.createElement(_entity_cell.EntityCell, {
    entityName: entityName,
    entityValue: entityValue,
    filter: filter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 10
    }
  });
}
function getInfluencersItems(anomalyInfluencers, influencerFilter, numToDisplay) {
  const items = [];
  for (let i = 0; i < numToDisplay; i++) {
    Object.keys(anomalyInfluencers[i]).forEach(influencerFieldName => {
      const value = anomalyInfluencers[i][influencerFieldName];
      items.push({
        title: influencerFieldName,
        description: getFilterEntity(influencerFieldName, value, influencerFilter)
      });
    });
  }
  return items;
}
const DetailsItems = ({
  anomaly,
  filter,
  modelPlotEnabled
}) => {
  const source = anomaly.source;

  // TODO - when multivariate analyses are more common,
  // look in each cause for a 'correlatedByFieldValue' field,
  let causes = [];
  const sourceCauses = source.causes || [];
  let singleCauseByFieldName;
  let singleCauseByFieldValue;
  if (sourceCauses.length === 1) {
    // Metrics and probability will already have been placed at the top level.
    // If cause has byFieldValue, move it to a top level fields for display.
    if (sourceCauses[0].by_field_name !== undefined) {
      singleCauseByFieldName = sourceCauses[0].by_field_name;
      singleCauseByFieldValue = sourceCauses[0].by_field_value;
    }
  } else {
    causes = sourceCauses.map(cause => {
      return {
        typical: cause.typical,
        actual: cause.actual,
        probability: cause.probability,
        // // Get the 'entity field name/value' to display in the cause -
        // // For by and over, use by_field_name/value (over_field_name/value are in the top level fields)
        // // For just an 'over' field - the over_field_name/value appear in both top level and cause.
        entityName: cause.by_field_name ? cause.by_field_name : cause.over_field_name,
        entityValue: cause.by_field_value ? cause.by_field_value : cause.over_field_value
      };
    });
  }
  const items = [];
  if (filter !== undefined) {
    if (source.partition_field_value !== undefined && source.partition_field_name !== undefined) {
      items.push({
        title: source.partition_field_name,
        description: getFilterEntity(source.partition_field_name, String(source.partition_field_value), filter)
      });
    }
    if (source.by_field_value !== undefined && source.by_field_name !== undefined) {
      items.push({
        title: source.by_field_name,
        description: getFilterEntity(source.by_field_name, source.by_field_value, filter)
      });
    }
    if (singleCauseByFieldName !== undefined && singleCauseByFieldValue !== undefined) {
      // Display byField of single cause.
      items.push({
        title: singleCauseByFieldName,
        description: getFilterEntity(singleCauseByFieldName, singleCauseByFieldValue, filter)
      });
    }
    if (source.over_field_value !== undefined && source.over_field_name !== undefined) {
      items.push({
        title: source.over_field_name,
        description: getFilterEntity(source.over_field_name, source.over_field_value, filter)
      });
    }
  }
  const anomalyTime = source[TIME_FIELD_NAME];
  let timeDesc = `${(0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(anomalyTime)}`;
  if (source.bucket_span !== undefined) {
    const anomalyEndTime = anomalyTime + source.bucket_span * 1000;
    timeDesc = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyTimeRangeLabel', {
      defaultMessage: '{anomalyTime} to {anomalyEndTime}',
      values: {
        anomalyTime: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(anomalyTime),
        anomalyEndTime: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(anomalyEndTime)
      }
    });
  }
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.timeTitle', {
      defaultMessage: 'Time'
    }),
    description: timeDesc
  });
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.functionTitle', {
      defaultMessage: 'Function'
    }),
    description: source.function !== _mlAnomalyUtils.ML_JOB_AGGREGATION.METRIC ? source.function : source.function_description
  });
  if (source.field_name !== undefined) {
    items.push({
      title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.fieldNameTitle', {
        defaultMessage: 'Field name'
      }),
      description: source.field_name
    });
  }
  const functionDescription = source.function_description || '';
  if (anomaly.actual !== undefined && (0, _mlAnomalyUtils.showActualForFunction)(functionDescription) === true) {
    items.push({
      title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.actualTitle', {
        defaultMessage: 'Actual'
      }),
      description: /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
        value: anomaly.actual,
        function: source.function,
        record: source,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 9
        }
      })
    });
  }
  if (anomaly.typical !== undefined && (0, _mlAnomalyUtils.showTypicalForFunction)(functionDescription) === true) {
    var _anomaly$source$anoma, _anomaly$source$anoma2;
    items.push({
      title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.typicalTitle', {
        defaultMessage: 'Typical'
      }),
      description: /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
        value: anomaly.typical,
        function: source.function,
        record: source,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 9
        }
      })
    });
    if (modelPlotEnabled === false && ((_anomaly$source$anoma = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma === void 0 ? void 0 : _anomaly$source$anoma.lower_confidence_bound) !== undefined && ((_anomaly$source$anoma2 = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma2 === void 0 ? void 0 : _anomaly$source$anoma2.upper_confidence_bound) !== undefined) {
      var _anomaly$source$anoma3, _anomaly$source$anoma4;
      items.push({
        title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.upperBoundsTitle', {
          defaultMessage: 'Upper bound'
        }),
        description: /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
          value: (_anomaly$source$anoma3 = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma3 === void 0 ? void 0 : _anomaly$source$anoma3.upper_confidence_bound,
          function: source.function,
          record: source,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 210,
            columnNumber: 11
          }
        })
      });
      items.push({
        title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.lowerBoundsTitle', {
          defaultMessage: 'Lower bound'
        }),
        description: /*#__PURE__*/_react.default.createElement(_anomaly_value_display.AnomalyValueDisplay, {
          value: (_anomaly$source$anoma4 = anomaly.source.anomaly_score_explanation) === null || _anomaly$source$anoma4 === void 0 ? void 0 : _anomaly$source$anoma4.lower_confidence_bound,
          function: source.function,
          record: source,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 223,
            columnNumber: 11
          }
        })
      });
    }
  }
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.jobIdTitle', {
      defaultMessage: 'Job ID'
    }),
    description: anomaly.jobId
  });
  items.push({
    title: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.recordScoreTitle', {
      defaultMessage: 'Record score'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      position: "left",
      content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.recordScoreTooltip', {
        defaultMessage: 'A normalized score between 0-100, which indicates the relative significance of the anomaly record result. This value might change as new data is analyzed.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 9
      }
    })),
    description: Math.floor(1000 * source.record_score) / 1000
  });
  items.push({
    title: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.initialRecordScoreTitle', {
      defaultMessage: 'Initial record score'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      position: "left",
      content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.initialRecordScoreTooltip', {
        defaultMessage: 'A normalized score between 0-100, which indicates the relative significance of the anomaly record when the bucket was initially processed.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 9
      }
    })),
    description: Math.floor(1000 * source.initial_record_score) / 1000
  });
  items.push({
    title: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.probabilityTitle', {
      defaultMessage: 'Probability'
    }),
    description:
    // @ts-expect-error parseFloat accepts a number
    source.probability !== undefined ? Number.parseFloat(source.probability).toPrecision(3) : ''
  });

  // If there was only one cause, the actual, typical and by_field
  // will already have been added for display.
  if (causes.length > 1) {
    causes.forEach((cause, index) => {
      const title = index === 0 ? _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.causeValuesTitle', {
        defaultMessage: '{causeEntityName} values',
        values: {
          causeEntityName: cause.entityName
        }
      }) : '';
      const description = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.causeValuesDescription', {
        defaultMessage: '{causeEntityValue} (actual {actualValue}, ' + 'typical {typicalValue}, probability {probabilityValue})',
        values: {
          causeEntityValue: cause.entityValue,
          actualValue: (0, _format_value.formatValue)(cause.actual, source.function),
          typicalValue: (0, _format_value.formatValue)(cause.typical, source.function),
          probabilityValue: cause.probability
        }
      });
      items.push({
        title,
        description
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '180px'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 13
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 13
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }))));
};
exports.DetailsItems = DetailsItems;
const AnomalyExplanationDetails = ({
  anomaly
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docsUrl = docLinks.links.ml.anomalyDetectionScoreExplanation;
  const explanation = anomaly.source.anomaly_score_explanation;
  if (explanation === undefined) {
    return null;
  }
  const initialScore = Math.floor(1000 * anomaly.source.initial_record_score) / 1000;
  const finalScore = Math.floor(1000 * anomaly.source.record_score) / 1000;
  const scoreDifference = initialScore - finalScore;
  const ACCEPTABLE_NORMALIZATION = 10;
  const yes = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.yes', {
    defaultMessage: 'Yes'
  });
  const no = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.no', {
    defaultMessage: 'No'
  });
  const explanationDetails = [];
  const anomalyType = getAnomalyType(explanation);
  if (anomalyType !== null) {
    explanationDetails.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyType",
        defaultMessage: "Anomaly type",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 373,
          columnNumber: 9
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, anomalyType)
    });
  }
  if (scoreDifference > ACCEPTABLE_NORMALIZATION) {
    explanationDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.recordScore",
        defaultMessage: "Record score reduction",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 386,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.recordScoreTooltip', {
          defaultMessage: 'The initial record score has been reduced based on the analysis of subsequent data.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 391,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 408,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 409,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(RecordScore, {
        score: initialScore,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 410,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 11
        }
      }, ` -> `), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 413,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(RecordScore, {
        score: finalScore,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 414,
          columnNumber: 13
        }
      })))
    });
  }
  const impactDetails = [];
  if (explanation.anomaly_characteristics_impact !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristics",
        defaultMessage: "Anomaly characteristics impact",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 427,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: getImpactTooltip(explanation.anomaly_characteristics_impact, 'anomaly_characteristics'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 432,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(ImpactVisual, {
        score: explanation.anomaly_characteristics_impact,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 445,
          columnNumber: 20
        }
      })
    });
  }
  if (explanation.single_bucket_impact !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 452,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucket",
        defaultMessage: "Single bucket impact",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 453,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: getImpactTooltip(explanation.single_bucket_impact, 'single_bucket'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 458,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(ImpactVisual, {
        score: explanation.single_bucket_impact,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 468,
          columnNumber: 20
        }
      })
    });
  }
  if (explanation.multi_bucket_impact !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 474,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucket",
        defaultMessage: "Multi bucket impact",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 475,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: getImpactTooltip(explanation.multi_bucket_impact, 'multi_bucket'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 480,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(ImpactVisual, {
        score: explanation.multi_bucket_impact,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 490,
          columnNumber: 20
        }
      })
    });
  }
  if (explanation.high_variance_penalty !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 496,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.highVariance",
        defaultMessage: "High variance interval",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 497,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.highVarianceTooltip', {
          defaultMessage: 'Indicates reduction of anomaly score for the bucket with large confidence intervals. If a bucket has large confidence intervals, the score is reduced.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 502,
          columnNumber: 11
        }
      })),
      description: explanation.high_variance_penalty ? yes : no
    });
  }
  if (explanation.multimodal_distribution !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 524,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multimodal",
        defaultMessage: "Multi-modal distribution",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 525,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multimodalTooltip', {
          defaultMessage: 'Indicates whether the prior distribution of the time series is multi-modal or has a single mode.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 530,
          columnNumber: 11
        }
      })),
      description: explanation.multimodal_distribution ? yes : no
    });
  }
  if (explanation.incomplete_bucket_penalty !== undefined) {
    impactDetails.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 552,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.incompleteBucket",
        defaultMessage: "Incomplete bucket",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 553,
          columnNumber: 11
        }
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        color: "subdued",
        type: "question",
        className: "eui-alignTop",
        position: "left",
        content: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.incompleteBucketTooltip', {
          defaultMessage: 'If the bucket contains fewer samples than expected, the score is reduced.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 558,
          columnNumber: 11
        }
      })),
      description: explanation.incomplete_bucket_penalty ? yes : no
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationTitle",
    defaultMessage: "Anomaly explanation {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsUrl,
        target: "_blank",
        css: {
          marginLeft: '8px'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 587,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanation.learnMoreLinkText",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 588,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 599,
      columnNumber: 7
    }
  }), explanationDetails.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 603,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '220px'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 604,
      columnNumber: 13
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 607,
      columnNumber: 13
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 609,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 613,
      columnNumber: 7
    }
  }), impactDetails.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 617,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomaliesTable.anomalyDetails.impactOnScoreTitle",
    defaultMessage: "Impact on initial score",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 624,
      columnNumber: 11
    }
  }), impactDetails.map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      width: '220px'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 629,
      columnNumber: 17
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 17
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 15
    }
  })))) : null);
};
exports.AnomalyExplanationDetails = AnomalyExplanationDetails;
const RecordScore = ({
  score
}) => {
  const color = (0, _mlAnomalyUtils.useSeverityColor)(score);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      borderBottom: '2px solid'
    },
    style: {
      borderBottomColor: color
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 646,
      columnNumber: 5
    }
  }, score);
};
function getAnomalyType(explanation) {
  if (explanation === undefined || explanation.anomaly_length === undefined || explanation.anomaly_type === undefined) {
    return null;
  }
  const dip = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.anomalyType.dip', {
    defaultMessage: 'Dip over {anomalyLength, plural, one {# bucket} other {# buckets}}',
    values: {
      anomalyLength: explanation.anomaly_length
    }
  });
  const spike = _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyExplanationDetails.anomalyType.spike', {
    defaultMessage: 'Spike over {anomalyLength, plural, one {# bucket} other {# buckets}}',
    values: {
      anomalyLength: explanation.anomaly_length
    }
  });
  return explanation.anomaly_type === 'dip' ? dip : spike;
}
const impactTooltips = {
  anomaly_characteristics: {
    low: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristicsTooltip.low', {
      defaultMessage: 'Moderate impact from the duration and magnitude of the detected anomaly relative to the historical average.'
    }),
    medium: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristicsTooltip.medium', {
      defaultMessage: 'Medium impact from the duration and magnitude of the detected anomaly relative to the historical average.'
    }),
    high: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.anomalyCharacteristicsTooltip.high', {
      defaultMessage: 'High impact from the duration and magnitude of the detected anomaly relative to the historical average.'
    })
  },
  single_bucket: {
    low: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucketTooltip.low', {
      defaultMessage: 'The difference between actual and typical values in this bucket has a moderate impact.'
    }),
    medium: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucketTooltip.medium', {
      defaultMessage: 'The difference between actual and typical values in this bucket has a significant impact.'
    }),
    high: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.singleBucketTooltip.high', {
      defaultMessage: 'The difference between actual and typical values in this bucket has a high impact.'
    })
  },
  multi_bucket: {
    low: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucketTooltip.low', {
      defaultMessage: 'The differences between actual and typical values in the past 12 buckets have a moderate impact.'
    }),
    medium: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucketTooltip.medium', {
      defaultMessage: 'The differences between actual and typical values in the past 12 buckets have a significant impact.'
    }),
    high: _i18n.i18n.translate('xpack.ml.anomaliesTable.anomalyDetails.anomalyExplanationDetails.multiBucketTooltip.high', {
      defaultMessage: 'The differences between actual and typical values in the past 12 buckets have a high impact.'
    })
  }
};
function getImpactTooltip(score, type) {
  const value = (0, _mlAnomalyUtils.getAnomalyScoreExplanationImpactValue)(score);
  if (value < 3) {
    return impactTooltips[type].low;
  }
  if (value > 3) {
    return impactTooltips[type].high;
  }
  return impactTooltips[type].medium;
}
const ImpactVisual = ({
  score
}) => {
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const impact = (0, _mlAnomalyUtils.getAnomalyScoreExplanationImpactValue)(score);
  const boxPx = '10px';
  const emptyBox = colors.lightShade;
  const fullBox = colors.primary;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 781,
      columnNumber: 5
    }
  }, Array(5).fill(null).map((v, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 786,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        height: boxPx,
        width: boxPx,
        borderRadius: '2px'
      },
      style: {
        backgroundColor: impact > i ? fullBox : emptyBox
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 787,
        columnNumber: 15
      }
    }));
  }));
};