"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PassiveMap = PassiveMap;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("../../common");
var _create_basemap_layer_descriptor = require("../classes/layers/create_basemap_layer_descriptor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/lens/passive_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * PassiveMap compoment is a wrapper around a map embeddable where passive layer descriptor provides features
 * and layer does not auto-fetch features based on changes to pan, zoom, filter, query, timeRange, and other state changes.
 * To update features, update passiveLayer prop with new layer descriptor.
 * Contrast with traditional map (active map), where layers independently auto-fetch features
 * based on changes to pan, zoom, filter, query, timeRange, and other state changes
 */
function PassiveMap(props) {
  const isMounted = (0, _useMountedState.default)();
  const mapApiRef = (0, _react.useRef)(undefined);
  const beforeApiReadyPassiveLayerRef = (0, _react.useRef)(undefined);
  const onRenderCompleteSubscriptionRef = (0, _react.useRef)(undefined);
  (0, _react.useEffect)(() => {
    if (mapApiRef.current) {
      mapApiRef.current.updateLayerById(props.passiveLayer);
    } else {
      beforeApiReadyPassiveLayerRef.current = props.passiveLayer;
    }
  }, [props.passiveLayer]);
  (0, _react.useEffect)(() => {
    return () => {
      if (onRenderCompleteSubscriptionRef.current) {
        onRenderCompleteSubscriptionRef.current.unsubscribe();
      }
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mapEmbeddableContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    type: _common.MAP_SAVED_OBJECT_TYPE,
    getParentApi: () => ({
      hideFilterActions: true,
      getSerializedStateForChild: () => {
        const basemapLayerDescriptor = (0, _create_basemap_layer_descriptor.createBasemapLayerDescriptor)();
        const intialLayers = basemapLayerDescriptor ? [basemapLayerDescriptor] : [];
        return {
          rawState: {
            attributes: {
              title: '',
              layerListJSON: JSON.stringify([...intialLayers, props.passiveLayer])
            },
            filters: [],
            hidePanelTitles: true,
            viewMode: 'view',
            isLayerTOCOpen: false,
            mapSettings: {
              disableInteractive: false,
              hideToolbarOverlay: false,
              hideLayerControl: false,
              hideViewControl: false,
              initialLocation: _common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
              // this will startup based on data-extent
              autoFitToDataBounds: true // this will auto-fit when there are changes to the filter and/or query
            },
            isSharable: false
          },
          references: []
        };
      }
    }),
    onApiAvailable: api => {
      mapApiRef.current = api;
      if (beforeApiReadyPassiveLayerRef.current) {
        api.updateLayerById(beforeApiReadyPassiveLayerRef.current);
      }
      if (props.onRenderComplete) {
        onRenderCompleteSubscriptionRef.current = api.onRenderComplete$.subscribe(() => {
          if (isMounted() && props.onRenderComplete) {
            props.onRenderComplete();
          }
        });
      }
    },
    hidePanelChrome: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
}