"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestions = getSuggestions;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
var _get_ems_suggestion = require("./get_ems_suggestion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generate choroplath chart suggestions for buckets that match administrative boundaries from the Elastic Maps Service.
 */
function getSuggestions(suggestionRequest, emsFileLayers) {
  const {
    activeData,
    keptLayerIds,
    state,
    table
  } = suggestionRequest;
  if (!activeData) {
    return [];
  }
  const isUnchanged = state && table.changeType === 'unchanged';
  if (isUnchanged || keptLayerIds.length > 1 || keptLayerIds.length && table.layerId !== keptLayerIds[0]) {
    return [];
  }
  const [buckets, metrics] = (0, _lodash.partition)(table.columns, col => col.operation.isBucketed);
  if (buckets.length !== 1 || metrics.length !== 1) {
    return [];
  }
  const metric = metrics[0];
  const suggestions = [];
  buckets.filter(col => {
    return col.operation.dataType === 'string';
  }).forEach(bucket => {
    for (const tableId in activeData) {
      if (Object.hasOwn(activeData, tableId)) {
        const emsSuggestion = (0, _get_ems_suggestion.getEmsSuggestion)(emsFileLayers, activeData[tableId], bucket.columnId);
        if (emsSuggestion) {
          suggestions.push({
            title: _i18n.i18n.translate('xpack.maps.lens.choroplethChart.suggestionLabel', {
              defaultMessage: '{emsLayerLabel} by {metricLabel}',
              values: {
                emsLayerLabel: emsSuggestion.displayName,
                metricLabel: metric.operation.label.toLowerCase()
              }
            }),
            score: 0.7,
            state: {
              layerId: tableId,
              emsLayerId: emsSuggestion.layerId,
              emsField: emsSuggestion.field,
              valueAccessor: metric.columnId,
              regionAccessor: bucket.columnId
            },
            previewIcon: _chartIcons.IconRegionMap
          });
        }
      }
    }
  });
  return suggestions;
}