"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorMapSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _color_stops_ordinal = require("./color_stops_ordinal");
var _constants = require("../../../../../../common/constants");
var _color_stops_categorical = require("./color_stops_categorical");
var _color_palettes = require("../../../color_palettes");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/color/color_map_select.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CUSTOM_COLOR_MAP = 'CUSTOM_COLOR_MAP';
class ColorMapSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "_onColorPaletteSelect", selectedPaletteId => {
      const useCustomColorMap = selectedPaletteId === CUSTOM_COLOR_MAP;
      this.props.onChange({
        color: useCustomColorMap ? null : selectedPaletteId,
        useCustomColorMap,
        type: this.props.colorMapType
      });
    });
    (0, _defineProperty2.default)(this, "_onCustomColorMapChange", ({
      colorStops,
      isInvalid
    }) => {
      // Manage invalid custom color map in local state
      if (isInvalid) {
        this.setState({
          customColorMap: colorStops
        });
        return;
      }
      this.props.onChange({
        useCustomColorMap: true,
        customColorMap: colorStops,
        type: this.props.colorMapType
      });
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    if (nextProps.customColorMap === prevState.prevPropsCustomColorMap) {
      return null;
    }
    return {
      prevPropsCustomColorMap: nextProps.customColorMap,
      // reset tracker to latest value
      customColorMap: nextProps.customColorMap // reset customColorMap to latest value
    };
  }
  _renderColorMapToggle() {
    const options = [{
      value: _constants.COLOR_MAP_TYPE.ORDINAL,
      text: _i18n.i18n.translate('xpack.maps.styles.dynamicColorSelect.quantitativeLabel', {
        defaultMessage: 'As number'
      })
    }, {
      value: _constants.COLOR_MAP_TYPE.CATEGORICAL,
      text: _i18n.i18n.translate('xpack.maps.styles.dynamicColorSelect.qualitativeLabel', {
        defaultMessage: 'As category'
      })
    }];
    const selectedValue = this.props.styleProperty.isOrdinal() ? _constants.COLOR_MAP_TYPE.ORDINAL : _constants.COLOR_MAP_TYPE.CATEGORICAL;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: options,
      value: selectedValue,
      onChange: this.props.onColorMapTypeChange,
      "aria-label": _i18n.i18n.translate('xpack.maps.styles.dynamicColorSelect.qualitativeOrQuantitativeAriaLabel', {
        defaultMessage: 'Choose `As number` to map by number in a color range, or `As category`to categorize by color palette.'
      }),
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    });
  }
  _renderColorStopsInput() {
    if (!this.props.isCustomOnly && !this.props.useCustomColorMap) {
      return null;
    }
    let colorStopEditor;
    if (this.props.colorMapType === _constants.COLOR_MAP_TYPE.ORDINAL) {
      colorStopEditor = /*#__PURE__*/_react.default.createElement(_color_stops_ordinal.ColorStopsOrdinal, {
        colorStops: this.state.customColorMap,
        onChange: this._onCustomColorMapChange,
        swatches: this.props.swatches,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      });
    } else {
      colorStopEditor = /*#__PURE__*/_react.default.createElement(_color_stops_categorical.ColorStopsCategorical, {
        colorStops: this.state.customColorMap,
        field: this.props.styleProperty.getField(),
        getValueSuggestions: this.props.styleProperty.getValueSuggestions,
        onChange: this._onCustomColorMapChange,
        swatches: this.props.swatches,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, colorStopEditor));
  }
  _getColorPalettes() {
    if (this.props.colorMapType === _constants.COLOR_MAP_TYPE.CATEGORICAL) {
      return _color_palettes.CATEGORICAL_COLOR_PALETTES;
    }
    return this.props.invert ? _color_palettes.NUMERICAL_COLOR_PALETTES.map(paletteProps => {
      return {
        ...paletteProps,
        palette: [...paletteProps.palette].reverse()
      };
    }) : _color_palettes.NUMERICAL_COLOR_PALETTES;
  }
  _renderColorMapSelections() {
    if (this.props.isCustomOnly) {
      return null;
    }
    const palettesWithCustom = [{
      value: CUSTOM_COLOR_MAP,
      title: this.props.colorMapType === _constants.COLOR_MAP_TYPE.ORDINAL ? _i18n.i18n.translate('xpack.maps.style.customColorRampLabel', {
        defaultMessage: 'Custom color ramp'
      }) : _i18n.i18n.translate('xpack.maps.style.customColorPaletteLabel', {
        defaultMessage: 'Custom color palette'
      }),
      type: 'text',
      'data-test-subj': `colorMapSelectOption_${CUSTOM_COLOR_MAP}`
    }, ...this._getColorPalettes()];
    const toggle = this.props.showColorMapTypeToggle ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 7
      }
    }, this._renderColorMapToggle()) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'xs',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }, toggle, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
      palettes: palettesWithCustom,
      onChange: this._onColorPaletteSelect,
      valueOfSelected: this.props.useCustomColorMap ? CUSTOM_COLOR_MAP : this.props.colorPaletteId,
      compressed: true,
      "data-test-subj": `colorMapSelect_${this.props.styleProperty.getStyleName()}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 7
      }
    }, this._renderColorMapSelections(), this._renderColorStopsInput());
  }
}
exports.ColorMapSelect = ColorMapSelect;