"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionEditor = DimensionEditor;
exports.DimensionEditorAdditionalSection = DimensionEditorAdditionalSection;
exports.DimensionEditorDataExtraComponent = DimensionEditorDataExtraComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _coloring = require("@kbn/coloring");
var _public = require("@kbn/expression-metric-vis-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _react2 = require("@emotion/react");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _visualizationUtils = require("@kbn/visualization-utils");
var _palettes = require("@kbn/palettes");
var _shared_components = require("../../shared_components");
var _palette_config = require("./palette_config");
var _visualization = require("./visualization");
var _collapse_setting = require("../../shared_components/collapse_setting");
var _icon_set = require("../../shared_components/icon_set");
var _helpers = require("./helpers");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/metric/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DimensionEditor(props) {
  const {
    state,
    accessor
  } = props;
  const idPrefix = (0, _eui.htmlIdGenerator)()();
  switch (accessor) {
    case state === null || state === void 0 ? void 0 : state.metricAccessor:
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "lnsMetricDimensionEditor_primary_metric",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(PrimaryMetricEditor, (0, _extends2.default)({}, props, {
        idPrefix: idPrefix,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 11
        }
      })));
    case state.secondaryMetricAccessor:
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "lnsMetricDimensionEditor_secondary_metric",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(SecondaryMetricEditor, (0, _extends2.default)({}, props, {
        idPrefix: idPrefix,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      })));
    case state.maxAccessor:
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "lnsMetricDimensionEditor_maximum",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(MaximumEditor, (0, _extends2.default)({}, props, {
        idPrefix: idPrefix,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      })));
    case state.breakdownByAccessor:
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "lnsMetricDimensionEditor_breakdown",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(BreakdownByEditor, (0, _extends2.default)({}, props, {
        idPrefix: idPrefix,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      })));
    default:
      return null;
  }
}
function BreakdownByEditor({
  setState,
  state
}) {
  var _state$maxCols;
  const setMaxCols = (0, _react.useCallback)(columns => {
    setState({
      ...state,
      maxCols: parseInt(columns, 10)
    });
  }, [setState, state]);
  const {
    inputValue: currentMaxCols,
    handleInputChange: handleMaxColsChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: setMaxCols,
    value: String((_state$maxCols = state.maxCols) !== null && _state$maxCols !== void 0 ? _state$maxCols : _visualization.DEFAULT_MAX_COLUMNS)
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.metric.maxColumns', {
      defaultMessage: 'Layout columns'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    min: 1,
    "data-test-subj": "lnsMetric_max_cols",
    value: currentMaxCols,
    onChange: ({
      target: {
        value
      }
    }) => handleMaxColsChange(value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })));
}
function MaximumEditor({
  setState,
  state,
  idPrefix
}) {
  return null;
}
const reversePostfix = '--reversed';
function useTrendPalettes() {
  const palettes = (0, _palettes.useKbnPalettes)();
  const computedPalettes = (0, _react.useMemo)(() => {
    const defaultKbnPalette = palettes.get(_palettes.KbnPalette.CompareTo);
    const trendPalettes = new Set([_palettes.KbnPalette.Complementary, _palettes.KbnPalette.Temperature]);
    const defaultPalette = {
      id: defaultKbnPalette.id,
      paletteId: defaultKbnPalette.id,
      name: defaultKbnPalette.name,
      reversed: false,
      colors: defaultKbnPalette.colors(3)
    };
    return {
      defaultPalette,
      allPalettes: [defaultPalette, {
        ...defaultPalette,
        id: `${_palettes.KbnPalette.CompareTo}${reversePostfix}`,
        name: _i18n.i18n.translate('xpack.lens.secondaryMetric.compareTo.dynamicColoring.palette.trendReversed.label', {
          defaultMessage: 'Trend reversed'
        }),
        reversed: true
      }, ...palettes.getAll().filter(({
        id
      }) => trendPalettes.has(id)).map(({
        id,
        colors,
        name
      }) => ({
        id,
        paletteId: id,
        name,
        colors: colors(3),
        reversed: false
      }))]
    };
  }, [palettes]);
  return computedPalettes;
}
function TrendEditor({
  accessor,
  idPrefix,
  setState,
  state,
  datasource
}) {
  const {
    isNumeric: secondaryMetricCanTrend
  } = (0, _shared_components.getAccessorType)(datasource, accessor);
  const {
    isNumeric: primaryMetricCanTrend
  } = (0, _shared_components.getAccessorType)(datasource, state === null || state === void 0 ? void 0 : state.metricAccessor);
  const {
    defaultPalette,
    allPalettes
  } = useTrendPalettes();

  // Translate palette to show it on the picker UI
  const palettesToShow = (0, _react.useMemo)(() => allPalettes.map(({
    id,
    name,
    colors,
    reversed
  }) => ({
    value: id,
    title: name,
    palette: reversed ? colors.slice().reverse() : colors,
    type: 'fixed'
  })), [allPalettes]);
  const canShowTrend = secondaryMetricCanTrend;
  if (!canShowTrend) {
    return null;
  }
  const secondaryTrend = state.secondaryTrend;
  if (!secondaryTrend || secondaryTrend.type !== 'dynamic') {
    return null;
  }
  const selectedPalette = secondaryTrend ? allPalettes.find(({
    paletteId,
    reversed
  }) => paletteId === secondaryTrend.paletteId && reversed === secondaryTrend.reversed) || defaultPalette : defaultPalette;
  const isPrimaryMetricOptionSelected = secondaryTrend.baselineValue === 'primary' && primaryMetricCanTrend;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.secondaryMetric.compareTo.staticColoring.palettePicker.label', {
      defaultMessage: 'Color palette'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    fullWidth: true,
    "data-test-subj": "lnsMetric_secondary_trend_palette",
    compressed: true,
    palettes: palettesToShow,
    onChange: newPalette => {
      const paletteDefinition = allPalettes.find(({
        id
      }) => id === newPalette);
      if (!paletteDefinition) {
        return;
      }
      setState({
        ...state,
        secondaryTrend: {
          ...secondaryTrend,
          paletteId: paletteDefinition.paletteId,
          reversed: Boolean(paletteDefinition.reversed)
        }
      });
    },
    valueOfSelected: selectedPalette.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.display', {
      defaultMessage: 'Display'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.display', {
      defaultMessage: 'Display'
    }),
    "data-test-subj": "lnsMetric_secondary_trend_display_buttons",
    options: [{
      id: `${idPrefix}display_icon`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.display.icon', {
        defaultMessage: 'Icon'
      }),
      'data-test-subj': 'lnsMetric_secondary_trend_display_icon'
    }, {
      id: `${idPrefix}display_value`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.display.value', {
        defaultMessage: 'Value'
      }),
      'data-test-subj': 'lnsMetric_secondary_trend_display_value'
    }, {
      id: `${idPrefix}display_both`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.display.both', {
        defaultMessage: 'Both'
      }),
      'data-test-subj': 'lnsMetric_secondary_trend_display_both'
    }],
    idSelected: `${idPrefix}display_${(secondaryTrend === null || secondaryTrend === void 0 ? void 0 : secondaryTrend.visuals) || 'both'}`,
    onChange: id => {
      const visualsMode = id.replace(`${idPrefix}display_`, '');
      setState({
        ...state,
        secondaryTrend: {
          ...secondaryTrend,
          visuals: visualsMode || 'both'
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo', {
      defaultMessage: 'Compare to'
    }),
    helpText: isPrimaryMetricOptionSelected ? _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.primaryHelpText', {
      defaultMessage: 'Displays the trend as the primary metric minus the secondary.'
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.baseline', {
      defaultMessage: 'Compare to'
    }),
    "data-test-subj": "lnsMetric_secondary_trend_baseline_buttons",
    options: [{
      id: `${idPrefix}static`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.baseline.static', {
        defaultMessage: 'Static value'
      }),
      'data-test-subj': 'lnsMetric_secondary_trend_baseline_static'
    }, {
      id: `${idPrefix}primary`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.baseline.primary', {
        defaultMessage: 'Primary metric'
      }),
      'data-test-subj': 'lnsMetric_secondary_trend_baseline_primary',
      isDisabled: !primaryMetricCanTrend,
      toolTipContent: primaryMetricCanTrend ? undefined : _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.compareTo.baseline.primary.disabled', {
        defaultMessage: 'Primary metric must be numeric to use it as baseline'
      })
    }],
    idSelected: `${idPrefix}${isPrimaryMetricOptionSelected ? 'primary' : 'static'}`,
    onChange: id => {
      const baselineMode = id.replace(idPrefix, '');
      setState({
        ...state,
        secondaryTrend: {
          ...secondaryTrend,
          baselineValue: baselineMode === 'primary' ? 'primary' : 0
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 11
    }
  }), !isPrimaryMetricOptionSelected ? /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DebouncedInput, {
    "data-test-subj": "lnsMetric_secondary_trend_baseline_input",
    compressed: true,
    fullWidth: true,
    defaultValue: '0',
    type: "number",
    value: typeof (secondaryTrend === null || secondaryTrend === void 0 ? void 0 : secondaryTrend.baselineValue) === 'number' ? String(secondaryTrend.baselineValue) : '',
    onChange: newValue => {
      setState({
        ...state,
        secondaryTrend: {
          ...secondaryTrend,
          baselineValue: Number(newValue)
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 13
    }
  }) : null)));
}
function SecondaryMetricEditor({
  accessor,
  idPrefix,
  frame,
  layerId,
  setState,
  state,
  datasource
}) {
  var _getColumnByAccessor, _frame$activeData, _frame$activeData$lay, _state$secondaryLabel;
  const columnName = (_getColumnByAccessor = (0, _utils.getColumnByAccessor)(accessor, (_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$lay = _frame$activeData[layerId]) === null || _frame$activeData$lay === void 0 ? void 0 : _frame$activeData$lay.columns)) === null || _getColumnByAccessor === void 0 ? void 0 : _getColumnByAccessor.name;
  const defaultSecondaryLabel = columnName || '';
  const {
    isNumeric: isNumericType
  } = (0, _shared_components.getAccessorType)(datasource, accessor);
  const {
    isNumeric: isPrimaryMetricNumeric
  } = (0, _shared_components.getAccessorType)(datasource, state.metricAccessor);
  const colorMode = (0, _helpers.getColorMode)(state.secondaryTrend, isNumericType);
  const [prevColorConfig, setPrevColorConfig] = (0, _react.useState)({
    dynamic: undefined,
    static: undefined
  });
  const setColor = (0, _react.useCallback)(color => {
    setState({
      ...state,
      secondaryTrend: {
        type: 'static',
        color
      }
    });
  }, [setState, state]);
  const getColor = (0, _react.useCallback)(() => {
    var _state$secondaryTrend;
    return ((_state$secondaryTrend = state.secondaryTrend) === null || _state$secondaryTrend === void 0 ? void 0 : _state$secondaryTrend.type) === 'static' ? state.secondaryTrend.color : _constants.SECONDARY_DEFAULT_STATIC_COLOR;
  }, [state]);
  const secondaryLabelConfig = (0, _helpers.getSecondaryLabelSelected)(state, {
    defaultSecondaryLabel,
    colorMode,
    isPrimaryMetricNumeric
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.secondaryLabel', {
      defaultMessage: 'Label'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.secondaryLabel', {
      defaultMessage: 'Label'
    }),
    "data-test-subj": "lnsMetric_seondaryLabel_buttons",
    options: [{
      id: `${idPrefix}auto`,
      label: _i18n.i18n.translate('xpack.lens.metric.seondaryLabel.auto', {
        defaultMessage: 'Auto'
      }),
      'data-test-subj': 'lnsMetric_seondaryLabel_auto',
      value: undefined
    }, {
      id: `${idPrefix}custom`,
      label: _i18n.i18n.translate('xpack.lens.metric.seondaryLabel.custom', {
        defaultMessage: 'Custom'
      }),
      'data-test-subj': 'lnsMetric_seondaryLabel_custom',
      value: defaultSecondaryLabel
    }, {
      id: `${idPrefix}none`,
      label: _i18n.i18n.translate('xpack.lens.metric.seondaryLabel.none', {
        defaultMessage: 'None'
      }),
      'data-test-subj': 'lnsMetric_seondaryLabel_none',
      value: ''
    }],
    idSelected: `${idPrefix}${secondaryLabelConfig.mode}`,
    onChange: (_id, secondaryLabel) => {
      setState({
        ...state,
        secondaryLabel
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 11
    }
  }), secondaryLabelConfig.mode === 'custom' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DebouncedInput, {
    "data-test-subj": "lnsMetric_prefix_custom_input",
    compressed: true,
    value: secondaryLabelConfig.label,
    onChange: newSecondaryLabel => {
      setState({
        ...state,
        secondaryLabel: newSecondaryLabel
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 15
    }
  })))), secondaryLabelConfig.mode !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.labelPosition', {
      defaultMessage: 'Label position'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.labelPosition', {
      defaultMessage: 'Label position'
    }),
    options: [{
      id: `${idPrefix}before`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.labelPosition.before', {
        defaultMessage: 'Before'
      }),
      value: 'before'
    }, {
      id: `${idPrefix}after`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.labelPosition.after', {
        defaultMessage: 'After'
      }),
      value: 'after'
    }],
    idSelected: `${idPrefix}${(_state$secondaryLabel = state.secondaryLabelPosition) !== null && _state$secondaryLabel !== void 0 ? _state$secondaryLabel : _constants.metricStateDefaults.secondaryLabelPosition}`,
    onChange: (_id, secondaryLabelPosition) => {
      setState({
        ...state,
        secondaryLabelPosition
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 542,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.colorByValue.label', {
      defaultMessage: 'Color by value'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 577,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.colorByValue.label', {
      defaultMessage: 'Color by value'
    }),
    "data-test-subj": "lnsMetric_color_mode_buttons",
    options: [{
      id: `${idPrefix}none`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.colorMode.none', {
        defaultMessage: 'None'
      }),
      'data-test-subj': 'lnsMetric_color_mode_none'
    }, {
      id: `${idPrefix}static`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.colorMode.static', {
        defaultMessage: 'Static'
      }),
      'data-test-subj': 'lnsMetric_color_mode_static'
    }, {
      id: `${idPrefix}dynamic`,
      label: _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.colorMode.dynamic', {
        defaultMessage: 'Dynamic'
      }),
      'data-test-subj': 'lnsMetric_color_mode_dynamic',
      isDisabled: !isNumericType,
      toolTipContent: isNumericType ? undefined : _i18n.i18n.translate('xpack.lens.metric.secondaryMetric.colorMode.dynamic.disabled', {
        defaultMessage: 'Dynamic coloring is only available for numeric fields'
      })
    }],
    idSelected: `${idPrefix}${colorMode}`,
    onChange: id => {
      const newColorMode = id.replace(idPrefix, '');
      const secondaryTrend = newColorMode !== 'none' && prevColorConfig[newColorMode] != null ? prevColorConfig[newColorMode] : (0, _helpers.getDefaultConfigForMode)(newColorMode);
      setState({
        ...state,
        secondaryTrend
      });

      // save previous trend config
      if (state.secondaryTrend && state.secondaryTrend.type !== 'none') {
        setPrevColorConfig({
          ...prevColorConfig,
          [state.secondaryTrend.type]: state.secondaryTrend
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 584,
      columnNumber: 9
    }
  })), colorMode === 'static' ? /*#__PURE__*/_react.default.createElement(StaticColorControl, {
    getColor: getColor,
    setColor: setColor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 645,
      columnNumber: 9
    }
  }) : null, colorMode === 'dynamic' ? /*#__PURE__*/_react.default.createElement(TrendEditor, {
    accessor: accessor,
    idPrefix: idPrefix,
    setState: setState,
    state: state,
    datasource: datasource,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 648,
      columnNumber: 9
    }
  }) : null);
}
const supportingVisualization = state => state.trendlineLayerId ? 'trendline' : (0, _visualization.showingBar)(state) ? 'bar' : 'panel';
function PrimaryMetricEditor(props) {
  var _state$palette, _state$palette$params, _frame$activeData2, _currentMinMax$min, _currentMinMax$max;
  const {
    state,
    setState,
    frame,
    accessor,
    idPrefix,
    isInlineEditing
  } = props;
  const {
    isNumeric: isMetricNumeric
  } = (0, _shared_components.getAccessorType)(props.datasource, accessor);
  const euiTheme = (0, _eui.useEuiTheme)();
  const setColor = (0, _react.useCallback)(color => {
    setState({
      ...state,
      color: color === '' ? undefined : color
    });
  }, [setState, state]);
  const getColor = (0, _react.useCallback)(() => {
    return state.color || (0, _visualization.getDefaultColor)(state, isMetricNumeric);
  }, [state, isMetricNumeric]);
  if (accessor == null) {
    return null;
  }
  const hasDynamicColoring = Boolean(isMetricNumeric && state.palette);
  const supportsPercentPalette = Boolean(state.maxAccessor || state.breakdownByAccessor && !state.collapseFn || ((_state$palette = state.palette) === null || _state$palette === void 0 ? void 0 : (_state$palette$params = _state$palette.params) === null || _state$palette$params === void 0 ? void 0 : _state$palette$params.rangeType) === 'percent');
  const activePalette = state.palette || {
    type: 'palette',
    name: (supportsPercentPalette ? _palette_config.defaultPercentagePaletteParams : _palette_config.defaultNumberPaletteParams).name,
    params: {
      ...(supportsPercentPalette ? _palette_config.defaultPercentagePaletteParams : _palette_config.defaultNumberPaletteParams)
    }
  };
  const currentMinMax = (0, _public.getDataBoundsForPalette)({
    metric: state.metricAccessor,
    max: state.maxAccessor,
    // if we're collapsing, pretend like there's no breakdown to match the activeData
    breakdownBy: !state.collapseFn ? state.breakdownByAccessor : undefined
  }, (_frame$activeData2 = frame.activeData) === null || _frame$activeData2 === void 0 ? void 0 : _frame$activeData2[state.layerId]);
  const displayStops = (0, _coloring.applyPaletteParams)(props.paletteService, activePalette, {
    min: (_currentMinMax$min = currentMinMax.min) !== null && _currentMinMax$min !== void 0 ? _currentMinMax$min : _coloring.DEFAULT_MIN_STOP,
    max: (_currentMinMax$max = currentMinMax.max) !== null && _currentMinMax$max !== void 0 ? _currentMinMax$max : _coloring.DEFAULT_MAX_STOP
  });
  const showVisTextColorSwatches = supportingVisualization(state) === 'panel' && state.applyColorTo === 'value';
  const colorByValue = state.palette ? 'dynamic' : 'static';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isMetricNumeric && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.colorByValue.label', {
      defaultMessage: 'Color by value'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 724,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.colorByValue.label', {
      defaultMessage: 'Color by value'
    }),
    "data-test-subj": "lnsMetric_color_mode_buttons",
    options: [{
      id: `${idPrefix}static`,
      label: _i18n.i18n.translate('xpack.lens.metric.colorMode.static', {
        defaultMessage: 'Static'
      }),
      value: 'static',
      'data-test-subj': 'lnsMetric_color_mode_static'
    }, {
      id: `${idPrefix}dynamic`,
      label: _i18n.i18n.translate('xpack.lens.metric.colorMode.dynamic', {
        defaultMessage: 'Dynamic'
      }),
      value: 'dynamic',
      'data-test-subj': 'lnsMetric_color_mode_dynamic'
    }],
    idSelected: `${idPrefix}${colorByValue}`,
    onChange: (_id, newColorByValue) => {
      if (newColorByValue === colorByValue) return;
      setState({
        ...state,
        ...(newColorByValue === 'dynamic' ? {
          palette: {
            ...activePalette,
            params: {
              ...activePalette.params,
              stops: displayStops
            }
          },
          color: undefined
        } : {
          palette: undefined,
          color: undefined
        })
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 731,
      columnNumber: 11
    }
  })), hasDynamicColoring ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.paletteMetricGradient.label', {
      defaultMessage: 'Color mapping'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 783,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.PalettePanelContainer, {
    palette: displayStops.map(({
      color
    }) => color),
    siblingRef: props.panelRef,
    isInlineEditing: isInlineEditing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 790,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_coloring.CustomizablePalette, {
    palettes: props.paletteService,
    activePalette: activePalette,
    dataBounds: currentMinMax,
    showRangeTypeSelector: supportsPercentPalette,
    setPalette: newPalette => {
      setState({
        ...state,
        palette: newPalette
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 795,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(StaticColorControl, (0, _extends2.default)({
    getColor: getColor,
    setColor: setColor
  }, showVisTextColorSwatches ? {
    swatches: visTextColorSwatches(euiTheme)
  } : undefined, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 810,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.icon', {
      defaultMessage: 'Icon decoration'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 816,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.IconSelect, {
    customIconSet: _icon_set.metricIconsSet,
    value: state === null || state === void 0 ? void 0 : state.icon,
    onChange: newIcon => {
      if (state.icon === newIcon) return;

      // If no icon selected, remove icon and iconAlign properties from the state
      if (newIcon === 'empty') {
        const {
          icon,
          iconAlign,
          ...restState
        } = state;
        setState({
          ...restState
        });
        return;
      }

      // If both icon and iconAlign are set, only update icon
      if (state.icon && state.iconAlign) {
        setState({
          ...state,
          icon: newIcon
        });
        return;
      }

      // If icon is set but iconAlign is missing, set legacy align
      // same check as in x-pack/platform/plugins/shared/lens/public/visualizations/metric/to_expression.ts
      if (state.icon && !state.iconAlign) {
        setState({
          ...state,
          icon: newIcon,
          iconAlign: _constants.legacyMetricStateDefaults.iconAlign
        });
        return;
      }

      // If icon is missing, always set iconAlign to the default
      setState({
        ...state,
        icon: newIcon,
        iconAlign: _constants.metricStateDefaults.iconAlign
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 823,
      columnNumber: 9
    }
  })));
}
const visTextColorSwatches = ({
  euiTheme: {
    colors: {
      vis
    }
  }
}) => [vis.euiColorVisText0, vis.euiColorVisText1, vis.euiColorVisText2, vis.euiColorVisText3, vis.euiColorVisText4, vis.euiColorVisText5, vis.euiColorVisText6, vis.euiColorVisText7, vis.euiColorVisText8, vis.euiColorVisText9];
function StaticColorControl({
  getColor,
  setColor,
  swatches
}) {
  const colorLabel = _i18n.i18n.translate('xpack.lens.metric.color', {
    defaultMessage: 'Color'
  });
  const {
    inputValue: currentColor,
    handleInputChange: handleColorChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: setColor,
    value: getColor()
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: colorLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 909,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    onChange: handleColorChange,
    color: currentColor,
    "aria-label": colorLabel,
    showAlpha: true,
    swatches: swatches,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 910,
      columnNumber: 7
    }
  }));
}
function DimensionEditorAdditionalSection({
  state,
  datasource,
  setState,
  addLayer,
  removeLayer,
  accessor,
  frame
}) {
  var _datasource$getOperat, _datasource$getOperat2, _state$progressDirect, _state$applyColorTo;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isNumeric: isMetricNumeric
  } = (0, _shared_components.getAccessorType)(datasource, accessor);
  if (accessor !== state.metricAccessor || !isMetricNumeric) {
    return null;
  }
  const idPrefix = (0, _eui.htmlIdGenerator)()();
  const hasDefaultTimeField = datasource === null || datasource === void 0 ? void 0 : datasource.hasDefaultTimeField();
  const metricHasReducedTimeRange = Boolean(state.metricAccessor && (datasource === null || datasource === void 0 ? void 0 : (_datasource$getOperat = datasource.getOperationForColumnId(state.metricAccessor)) === null || _datasource$getOperat === void 0 ? void 0 : _datasource$getOperat.hasReducedTimeRange));
  const secondaryMetricHasReducedTimeRange = Boolean(state.secondaryMetricAccessor && (datasource === null || datasource === void 0 ? void 0 : (_datasource$getOperat2 = datasource.getOperationForColumnId(state.secondaryMetricAccessor)) === null || _datasource$getOperat2 === void 0 ? void 0 : _datasource$getOperat2.hasReducedTimeRange));
  const supportingVisHelpTexts = [];
  const supportsTrendline = hasDefaultTimeField && !metricHasReducedTimeRange && !secondaryMetricHasReducedTimeRange;
  if (!supportsTrendline) {
    supportingVisHelpTexts.push(!hasDefaultTimeField ? _i18n.i18n.translate('xpack.lens.metric.supportingVis.needDefaultTimeField', {
      defaultMessage: 'Line visualizations require use of a data view with a default time field.'
    }) : metricHasReducedTimeRange ? _i18n.i18n.translate('xpack.lens.metric.supportingVis.metricHasReducedTimeRange', {
      defaultMessage: 'Line visualizations cannot be used when a reduced time range is applied to the primary metric.'
    }) : secondaryMetricHasReducedTimeRange ? _i18n.i18n.translate('xpack.lens.metric.supportingVis.secondaryMetricHasReducedTimeRange', {
      defaultMessage: 'Line visualizations cannot be used when a reduced time range is applied to the secondary metric.'
    }) : '');
  }
  if (!state.maxAccessor) {
    supportingVisHelpTexts.push(_i18n.i18n.translate('xpack.lens.metric.summportingVis.needMaxDimension', {
      defaultMessage: 'Bar visualizations require a maximum value to be defined.'
    }));
  }
  const buttonIdPrefix = `${idPrefix}--`;
  const selectedSupportingVisualization = supportingVisualization(state);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded lnsIndexPatternDimensionEditor--collapseNext",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 991,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
          margin-bottom: ${euiTheme.size.base};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 992,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 998,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.lens.metric.supportingVis.label', {
    defaultMessage: 'Supporting visualization'
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.supportingVis.type', {
      defaultMessage: 'Type'
    }),
    helpText: supportingVisHelpTexts.map(text => /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1013,
        columnNumber: 13
      }
    }, text)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1006,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.supportingVis.type', {
      defaultMessage: 'Type'
    }),
    "data-test-subj": "lnsMetric_supporting_visualization_buttons",
    options: [{
      id: `${buttonIdPrefix}panel`,
      label: _i18n.i18n.translate('xpack.lens.metric.supportingVisualization.panel', {
        defaultMessage: 'Panel'
      }),
      value: 'panel',
      'data-test-subj': 'lnsMetric_supporting_visualization_panel'
    }, {
      id: `${buttonIdPrefix}trendline`,
      label: _i18n.i18n.translate('xpack.lens.metric.supportingVisualization.trendline', {
        defaultMessage: 'Line'
      }),
      isDisabled: !supportsTrendline,
      value: 'trendline',
      'data-test-subj': 'lnsMetric_supporting_visualization_trendline'
    }, {
      id: `${buttonIdPrefix}bar`,
      label: _i18n.i18n.translate('xpack.lens.metric.supportingVisualization.bar', {
        defaultMessage: 'Bar'
      }),
      isDisabled: !state.maxAccessor,
      value: 'bar',
      'data-test-subj': 'lnsMetric_supporting_visualization_bar'
    }],
    idSelected: `${buttonIdPrefix}${selectedSupportingVisualization}`,
    onChange: (_id, value) => {
      const supportingVisualizationType = value;
      if (supportingVisualizationType === supportingVisualization(state)) return;
      setState({
        ...state,
        showBar: supportingVisualizationType === 'bar',
        applyColorTo: _constants.metricStateDefaults.applyColorTo
      });
      if (supportingVisualizationType === 'trendline') {
        addLayer('metricTrendline');
      } else if (state.trendlineLayerId) {
        removeLayer(state.trendlineLayerId);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1016,
      columnNumber: 11
    }
  })), (0, _visualization.showingBar)(state) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.metric.progressDirectionLabel', {
      defaultMessage: 'Bar orientation'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1071,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.progressDirectionLabel', {
      defaultMessage: 'Bar orientation'
    }),
    "data-test-subj": "lnsMetric_progress_direction_buttons",
    options: [{
      id: `${idPrefix}vertical`,
      label: _i18n.i18n.translate('xpack.lens.metric.progressDirection.vertical', {
        defaultMessage: 'Vertical'
      }),
      'data-test-subj': 'lnsMetric_progress_bar_vertical'
    }, {
      id: `${idPrefix}horizontal`,
      label: _i18n.i18n.translate('xpack.lens.metric.progressDirection.horizontal', {
        defaultMessage: 'Horizontal'
      }),
      'data-test-subj': 'lnsMetric_progress_bar_horizontal'
    }],
    idSelected: `${idPrefix}${(_state$progressDirect = state.progressDirection) !== null && _state$progressDirect !== void 0 ? _state$progressDirect : 'vertical'}`,
    onChange: id => {
      const newDirection = id.replace(idPrefix, '');
      setState({
        ...state,
        progressDirection: newDirection
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1078,
      columnNumber: 13
    }
  })), selectedSupportingVisualization === 'panel' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.metric.supportingVis.applyColorTo', {
      defaultMessage: 'Apply color to'
    }),
    helpText: state.applyColorTo === 'value' && !state.palette ? /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1121,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.lens.metric.supportingVis.applyColorTo.staticColorValueHelp', {
      defaultMessage: 'Color palette has been automatically adjusted for provide the required contrast for text elements.'
    })) : state.applyColorTo === 'value' && state.palette ? /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 1131,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.lens.metric.supportingVis.applyColorTo.dynamicColorvalueHelp', {
      defaultMessage: 'Color scales might cause accessibility issues.'
    })) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "compressed",
    legend: _i18n.i18n.translate('xpack.lens.metric.supportingVis.applyColorTo', {
      defaultMessage: 'Apply color to'
    }),
    "data-test-subj": "lnsMetric_apply_color_to_buttons",
    options: [{
      id: `${buttonIdPrefix}background`,
      label: _i18n.i18n.translate('xpack.lens.metric.supportingVis.applyColorTo.background', {
        defaultMessage: 'Background'
      }),
      value: 'background'
    }, {
      id: `${buttonIdPrefix}value`,
      label: _i18n.i18n.translate('xpack.lens.metric.supportingVis.applyColorTo.value', {
        defaultMessage: 'Value'
      }),
      value: 'value'
    }],
    idSelected: `${buttonIdPrefix}${(_state$applyColorTo = state.applyColorTo) !== null && _state$applyColorTo !== void 0 ? _state$applyColorTo : _constants.metricStateDefaults.applyColorTo}`,
    onChange: (_id, newApplyColorTo) => {
      setState({
        ...state,
        applyColorTo: newApplyColorTo
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1142,
      columnNumber: 13
    }
  }))));
}
function DimensionEditorDataExtraComponent({
  groupId,
  datasource,
  state,
  setState
}) {
  const {
    isNumeric: isMetricNumeric
  } = (0, _shared_components.getAccessorType)(datasource, state.metricAccessor);
  if (!isMetricNumeric || groupId !== _constants.GROUP_ID.BREAKDOWN_BY) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
    value: state.collapseFn || '',
    onChange: collapseFn => {
      setState({
        ...state,
        collapseFn
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1193,
      columnNumber: 5
    }
  });
}