"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsDropdown = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/documents_dropdown/documents_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  dropdownLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentsdropdown.dropdownLabel', {
    defaultMessage: 'Documents:'
  }),
  editDocumentsButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentsDropdown.editDocumentsButtonLabel', {
    defaultMessage: 'Edit documents'
  }),
  popoverTitle: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentsDropdown.popoverTitle', {
    defaultMessage: 'Test documents'
  })
};
const panelStyle = {
  minWidth: '200px'
};
const DocumentsDropdown = ({
  documents,
  selectedDocumentIndex,
  updateSelectedDocument,
  openFlyout
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const managePipelineButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "documentsButton",
    onClick: () => setShowPopover(previousBool => !previousBool),
    iconType: "arrowDown",
    iconSide: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.selectedDocumentLabel', {
    defaultMessage: 'Document {selectedDocument}',
    values: {
      selectedDocument: selectedDocumentIndex + 1
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: managePipelineButton,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    "data-test-subj": "documentsDropdown",
    panelStyle: panelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    "data-test-subj": "documentList",
    options: documents.map((doc, index) => ({
      key: index.toString(),
      'data-test-subj': 'documentListItem',
      checked: selectedDocumentIndex === index ? 'on' : undefined,
      label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.documentLabel', {
        defaultMessage: 'Document {documentNumber}',
        values: {
          documentNumber: index + 1
        }
      })
    })),
    onChange: newOptions => {
      const selectedOption = newOptions.find(option => option.checked === 'on');
      if (selectedOption) {
        updateSelectedDocument(Number(selectedOption.key));
      }
      setShowPopover(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, i18nTexts.popoverTitle), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fullWidth: true,
    onClick: () => {
      openFlyout('documents');
      setShowPopover(false);
    },
    "data-test-subj": "editDocumentsButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, i18nTexts.editDocumentsButtonLabel)));
};
exports.DocumentsDropdown = DocumentsDropdown;