"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupProcessorsByCategory = exports.getProcessorTypesAndLabels = exports.extractProcessorDetails = exports.ProcessorTypeField = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _function = require("fp-ts/function");
var _Array = require("fp-ts/Array");
var _lodash = require("lodash");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _shared_imports = require("../../../../../../../shared_imports");
var _shared = require("../../../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/common_fields/processor_type_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const extractProcessorDetails = exports.extractProcessorDetails = (0, _function.flow)(Object.entries, (0, _Array.map)(([type, {
  label,
  forLicenseAtLeast,
  category
}]) => ({
  label,
  value: type,
  category,
  ...(forLicenseAtLeast ? {
    forLicenseAtLeast
  } : {})
})), arr => arr.sort((a, b) => a.label.localeCompare(b.label)));
const getProcessorTypesAndLabels = license => {
  return extractProcessorDetails((0, _shared.mapProcessorTypeToDescriptor)())
  // Filter out any processors that are not available for the current license type
  .filter(option => {
    return option.forLicenseAtLeast ? license === null || license === void 0 ? void 0 : license.hasAtLeast(option.forLicenseAtLeast) : true;
  })
  // Pick properties we need to build the categories
  .map(({
    value,
    label,
    category
  }) => ({
    label,
    value,
    category
  }));
};
exports.getProcessorTypesAndLabels = getProcessorTypesAndLabels;
const groupProcessorsByCategory = filteredProcessors => {
  return (0, _lodash.map)((0, _lodash.groupBy)(filteredProcessors, 'category'), (options, optionLabel) => ({
    label: optionLabel,
    options: (0, _lodash.map)(options, ({
      label,
      value
    }) => ({
      label,
      value
    }))
  }));
};
exports.groupProcessorsByCategory = groupProcessorsByCategory;
const {
  emptyField
} = _shared_imports.fieldValidators;
const typeConfig = {
  type: _shared_imports.FIELD_TYPES.COMBO_BOX,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.typeField.typeFieldLabel', {
    defaultMessage: 'Processor'
  }),
  deserializer: String,
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.typeField.fieldRequiredError', {
      defaultMessage: 'A type is required.'
    }))
  }]
};
const ProcessorTypeField = ({
  initialType
}) => {
  const {
    services: {
      documentation,
      license
    }
  } = (0, _shared_imports.useKibana)();
  const esDocUrl = documentation.getEsDocsBasePath();
  // Some processors are only available for certain license types
  const processorOptions = (0, _react.useMemo)(() => {
    // Get all processors
    const processors = getProcessorTypesAndLabels(license);
    // Group them by category so that they can be properly rendered by the EuiComboBox
    return groupProcessorsByCategory(processors);
  }, [license]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: typeConfig,
    defaultValue: initialType,
    path: "type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, typeField => {
    var _typeField$value;
    let selectedOptions;
    let description = '';
    if ((_typeField$value = typeField.value) !== null && _typeField$value !== void 0 && _typeField$value.length) {
      const type = typeField.value;
      const processorDescriptor = (0, _shared.getProcessorDescriptor)(type);
      if (processorDescriptor) {
        var _processorDescriptor$;
        description = (_processorDescriptor$ = processorDescriptor.typeDescription) !== null && _processorDescriptor$ !== void 0 ? _processorDescriptor$ : '';
        selectedOptions = [{
          label: processorDescriptor.label,
          value: type
        }];
      } else {
        // If there is no label for this processor type, just use the type as the label
        selectedOptions = [{
          label: type,
          value: type
        }];
      }
    } else {
      selectedOptions = [];
    }
    const error = typeField.getErrorsMessages();
    const isInvalid = error ? Boolean(error.length) : false;
    const onCreateComboOption = value => {
      // Note: for now, all validations for a comboBox array item have to be synchronous
      // If there is a need to support asynchronous validation, we'll work on it (and will need to update the <EuiComboBox /> logic).
      const {
        isValid
      } = typeField.validate({
        value,
        validationType: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM
      });
      if (!isValid) {
        // Return false to explicitly reject the user's input.
        return false;
      }
      typeField.setValue(value);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: typeField.label,
      labelAppend: typeField.labelAppend,
      helpText: typeof description === 'function' ? description(esDocUrl) : description,
      error: error,
      isInvalid: isInvalid,
      fullWidth: true,
      "data-test-subj": "processorTypeSelector",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.typeField.typeFieldComboboxPlaceholder', {
        defaultMessage: 'Start typing or select a processor'
      }),
      options: processorOptions,
      selectedOptions: selectedOptions,
      onCreateOption: onCreateComboOption,
      onChange: options => {
        var _ref;
        const [selection] = options;
        typeField.setValue((_ref = selection === null || selection === void 0 ? void 0 : selection.value) !== null && _ref !== void 0 ? _ref : '');
      },
      noSuggestions: false,
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "input",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }));
  });
};
exports.ProcessorTypeField = ProcessorTypeField;