"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmDataAccessClient = void 0;
var _server = require("@kbn/apm-data-access-plugin/server");
var _server2 = require("@kbn/data-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmDataAccessClient = ({
  libs,
  context,
  request
}) => {
  const hasPrivileges = async () => {
    const apmDataAccessStart = await libs.plugins.apmDataAccess.start();
    return apmDataAccessStart.hasPrivileges({
      request
    });
  };
  const getServices = async () => {
    const apmDataAccess = libs.plugins.apmDataAccess.setup;
    const coreContext = await context.core;
    const {
      savedObjects,
      uiSettings,
      elasticsearch
    } = coreContext;
    const savedObjectsClient = savedObjects.client;
    const esClient = elasticsearch.client.asCurrentUser;
    const uiSettingsClient = uiSettings.client;
    const [apmIndices, includeFrozen] = await Promise.all([apmDataAccess.getApmIndices(savedObjectsClient), uiSettingsClient.get(_server2.UI_SETTINGS.SEARCH_INCLUDE_FROZEN)]);
    const services = apmDataAccess.getServices({
      apmEventClient: new _server.APMEventClient({
        indices: apmIndices,
        options: {
          includeFrozen
        },
        debug: false,
        esClient,
        request
      })
    });
    return {
      ...services,
      getDocumentSources: async ({
        start,
        end,
        kuery = ''
      }) => {
        return services.getDocumentSources({
          start,
          end,
          kuery
        });
      }
    };
  };
  return {
    hasPrivileges,
    getServices
  };
};
exports.getApmDataAccessClient = getApmDataAccessClient;