"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callGetLogAnalysisIdFormats = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _latest = require("../../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callGetLogAnalysisIdFormats = async (requestArgs, fetch) => {
  const {
    logViewId,
    spaceId
  } = requestArgs;
  const response = await fetch(_latest.LOG_ANALYSIS_GET_ID_FORMATS, {
    method: 'POST',
    body: JSON.stringify(_latest.getLogAnalysisIdFormatsRequestPayloadRT.encode({
      data: {
        logViewId,
        spaceId
      }
    })),
    version: '1'
  });
  return (0, _ioTsUtils.decodeOrThrow)(_latest.getLogAnalysisIdFormatsSuccessResponsePayloadRT)(response);
};
exports.callGetLogAnalysisIdFormats = callGetLogAnalysisIdFormats;