"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeCategoryDatasetInMlAction = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _job_parameters = require("../../../../../../common/log_analysis/job_parameters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/analyze_dataset_in_ml_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnalyzeCategoryDatasetInMlAction = ({
  categorizationJobId,
  categoryId,
  dataset,
  timeRange
}) => {
  const {
    services: {
      ml,
      http,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const viewAnomalyInMachineLearningLink = (0, _public.useMlHref)(ml, http.basePath.get(), {
    page: _public.ML_PAGES.SINGLE_METRIC_VIEWER,
    pageState: {
      jobIds: [categorizationJobId],
      timeRange: {
        from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        mode: 'absolute'
      },
      entities: {
        [_job_parameters.partitionField]: dataset,
        mlcategory: `${categoryId}`
      }
    }
  }, [categorizationJobId]);
  const handleClick = (0, _react.useCallback)(e => {
    if (!viewAnomalyInMachineLearningLink || !(0, _public2.shouldHandleLinkEvent)(e)) return;
    application.navigateToUrl(viewAnomalyInMachineLearningLink);
  }, [application, viewAnomalyInMachineLearningLink]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: analyseCategoryDatasetInMlTooltipDescription,
    delay: "long",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": analyseCategoryDatasetInMlButtonLabel,
    iconType: "machineLearningApp",
    "data-test-subj": "analyzeCategoryDatasetInMlButton",
    href: viewAnomalyInMachineLearningLink,
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
};
exports.AnalyzeCategoryDatasetInMlAction = AnalyzeCategoryDatasetInMlAction;
const analyseCategoryDatasetInMlButtonLabel = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.analyzeCategoryInMlButtonLabel', {
  defaultMessage: 'Analyze in ML'
});
const analyseCategoryDatasetInMlTooltipDescription = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.analyzeCategoryInMlTooltipDescription', {
  defaultMessage: 'Analyze this category in the ML app.'
});