"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProcessStep = exports.ProcessStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _create_ml_jobs_button = require("./create_ml_jobs_button");
var _recreate_ml_jobs_button = require("./recreate_ml_jobs_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/process_step/process_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createProcessStep = props => ({
  title: processStepTitle,
  children: /*#__PURE__*/_react.default.createElement(ProcessStep, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 13
    }
  })),
  status: props.setupStatus.type === 'pending' ? 'incomplete' : props.setupStatus.type === 'failed' ? 'danger' : props.setupStatus.type === 'succeeded' ? 'complete' : undefined
});
exports.createProcessStep = createProcessStep;
const ProcessStep = ({
  cleanUpAndSetUp,
  errorMessages,
  isConfigurationValid,
  setUp,
  setupStatus,
  viewResults
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, setupStatus.type === 'pending' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.loadingText",
    defaultMessage: "Creating ML job...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }))) : setupStatus.type === 'failed' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.failureText",
    defaultMessage: "Something went wrong creating the necessary ML jobs. Please ensure all selected log indices exist.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }), setupStatus.reasons.map((errorMessage, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    key: i,
    color: "danger",
    iconType: "warning",
    title: errorCalloutTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, errorMessage))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessStepTryAgainButton",
    fill: true,
    onClick: cleanUpAndSetUp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.tryAgainButton",
    defaultMessage: "Try again",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))) : setupStatus.type === 'succeeded' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.successText",
    defaultMessage: "The ML jobs have been set up successfully",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraProcessStepViewResultsButton",
    fill: true,
    onClick: viewResults,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.steps.setupProcess.viewResultsButton",
    defaultMessage: "View results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }))) : setupStatus.type === 'required' ? /*#__PURE__*/_react.default.createElement(_create_ml_jobs_button.CreateMLJobsButton, {
    isDisabled: !isConfigurationValid,
    onClick: setUp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_recreate_ml_jobs_button.RecreateMLJobsButton, {
    isDisabled: !isConfigurationValid,
    onClick: cleanUpAndSetUp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }));
};
exports.ProcessStep = ProcessStep;
const errorCalloutTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.steps.setupProcess.errorCalloutTitle', {
  defaultMessage: 'An error occurred'
});
const processStepTitle = _i18n.i18n.translate('xpack.infra.analysisSetup.actionStepTitle', {
  defaultMessage: 'Create ML job'
});