"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FielddataFrequencyFilterAbsolute = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/fielddata_frequency_filter_absolute.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FielddataFrequencyFilterAbsolute = ({
  min,
  max
}) => {
  const minIsInvalid = !min.isChangingValue && min.errors.length > 0;
  const minErrorMessage = !min.isChangingValue && min.errors.length ? min.errors[0].message : null;
  const maxIsInvalid = !max.isChangingValue && max.errors.length > 0;
  const maxErrorMessage = !max.isChangingValue && max.errors.length ? max.errors[0].message : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: minIsInvalid || maxIsInvalid,
    error: minErrorMessage || maxErrorMessage,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.fielddata.frequencyFilterAbsoluteFieldLabel",
      defaultMessage: "Absolute frequency range",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayoutDelimited, {
    isInvalid: minIsInvalid || maxIsInvalid,
    startControl: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: min.value,
      onChange: min.onChange,
      isLoading: min.isValidating,
      isInvalid: minIsInvalid,
      fullWidth: true,
      "data-test-subj": "input",
      controlOnly: true,
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.frequencyFilterAbsoluteMinAriaLabel', {
        defaultMessage: 'Minimum absolute frequency'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }),
    endControl: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: max.value,
      onChange: max.onChange,
      isLoading: max.isValidating,
      isInvalid: maxIsInvalid,
      fullWidth: true,
      "data-test-subj": "input",
      controlOnly: true,
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fielddata.frequencyFilterAbsoluteMaxAriaLabel', {
        defaultMessage: 'Maximum absolute frequency'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }));
};
exports.FielddataFrequencyFilterAbsolute = FielddataFrequencyFilterAbsolute;