"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDeserializer = void 0;
var _lodash = require("lodash");
var _policies = require("../../../lib/policies");
var _lib = require("../../../lib");
var _lib2 = require("../lib");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDeserializer = isCloudEnabled => policy => {
  var _hot$actions, _hot$actions2, _hot$actions2$forceme, _hot$actions3, _hot$actions$shrink, _hot$actions4, _warm$actions, _warm$actions$forceme, _warm$actions2, _warm$actions$shrink, _warm$actions3, _cold$actions, _cold$actions2, _result$phases$hot, _result$phases$hot$ac, _result$phases$hot2, _result$phases$hot2$a, _result$phases$hot3, _result$phases$hot3$a;
  const {
    phases: {
      hot,
      warm,
      cold,
      frozen,
      delete: deletePhase
    }
  } = policy;
  let defaultRepository = (0, _lib2.getDefaultRepository)([hot === null || hot === void 0 ? void 0 : hot.actions.searchable_snapshot, cold === null || cold === void 0 ? void 0 : cold.actions.searchable_snapshot, frozen === null || frozen === void 0 ? void 0 : frozen.actions.searchable_snapshot]);
  if (!defaultRepository && isCloudEnabled) {
    defaultRepository = _constants.CLOUD_DEFAULT_REPO;
  }
  const _meta = {
    hot: {
      isUsingDefaultRollover: (0, _lib.isUsingDefaultRollover)(policy),
      customRollover: {
        enabled: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions = hot.actions) === null || _hot$actions === void 0 ? void 0 : _hot$actions.rollover)
      },
      bestCompression: (hot === null || hot === void 0 ? void 0 : (_hot$actions2 = hot.actions) === null || _hot$actions2 === void 0 ? void 0 : (_hot$actions2$forceme = _hot$actions2.forcemerge) === null || _hot$actions2$forceme === void 0 ? void 0 : _hot$actions2$forceme.index_codec) === 'best_compression',
      readonlyEnabled: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions3 = hot.actions) === null || _hot$actions3 === void 0 ? void 0 : _hot$actions3.readonly),
      shrink: {
        isUsingShardSize: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions$shrink = hot.actions.shrink) === null || _hot$actions$shrink === void 0 ? void 0 : _hot$actions$shrink.max_primary_shard_size)
      },
      downsample: {
        enabled: Boolean(hot === null || hot === void 0 ? void 0 : (_hot$actions4 = hot.actions) === null || _hot$actions4 === void 0 ? void 0 : _hot$actions4.downsample)
      }
    },
    warm: {
      enabled: Boolean(warm),
      warmPhaseOnRollover: warm === undefined ? true : Boolean(warm.min_age === '0ms'),
      bestCompression: (warm === null || warm === void 0 ? void 0 : (_warm$actions = warm.actions) === null || _warm$actions === void 0 ? void 0 : (_warm$actions$forceme = _warm$actions.forcemerge) === null || _warm$actions$forceme === void 0 ? void 0 : _warm$actions$forceme.index_codec) === 'best_compression',
      dataTierAllocationType: (0, _lib.determineDataTierAllocationType)(warm === null || warm === void 0 ? void 0 : warm.actions),
      readonlyEnabled: Boolean(warm === null || warm === void 0 ? void 0 : (_warm$actions2 = warm.actions) === null || _warm$actions2 === void 0 ? void 0 : _warm$actions2.readonly),
      minAgeToMilliSeconds: -1,
      shrink: {
        isUsingShardSize: Boolean(warm === null || warm === void 0 ? void 0 : (_warm$actions$shrink = warm.actions.shrink) === null || _warm$actions$shrink === void 0 ? void 0 : _warm$actions$shrink.max_primary_shard_size)
      },
      downsample: {
        enabled: Boolean(warm === null || warm === void 0 ? void 0 : (_warm$actions3 = warm.actions) === null || _warm$actions3 === void 0 ? void 0 : _warm$actions3.downsample)
      }
    },
    cold: {
      enabled: Boolean(cold),
      dataTierAllocationType: (0, _lib.determineDataTierAllocationType)(cold === null || cold === void 0 ? void 0 : cold.actions),
      readonlyEnabled: Boolean(cold === null || cold === void 0 ? void 0 : (_cold$actions = cold.actions) === null || _cold$actions === void 0 ? void 0 : _cold$actions.readonly),
      minAgeToMilliSeconds: -1,
      downsample: {
        enabled: Boolean(cold === null || cold === void 0 ? void 0 : (_cold$actions2 = cold.actions) === null || _cold$actions2 === void 0 ? void 0 : _cold$actions2.downsample)
      }
    },
    frozen: {
      enabled: Boolean(frozen),
      minAgeToMilliSeconds: -1
    },
    delete: {
      enabled: Boolean(deletePhase),
      minAgeToMilliSeconds: -1
    },
    searchableSnapshot: {
      repository: defaultRepository
    }
  };
  const result = (0, _lodash.cloneDeep)({
    ...policy,
    _meta
  });
  if ((_result$phases$hot = result.phases.hot) !== null && _result$phases$hot !== void 0 && (_result$phases$hot$ac = _result$phases$hot.actions) !== null && _result$phases$hot$ac !== void 0 && _result$phases$hot$ac.rollover) {
    if (result.phases.hot.actions.rollover.max_size) {
      const maxSize = (0, _policies.splitSizeAndUnits)(result.phases.hot.actions.rollover.max_size);
      result.phases.hot.actions.rollover.max_size = maxSize.size;
      result._meta.hot.customRollover.maxStorageSizeUnit = maxSize.units;
    }
    if (result.phases.hot.actions.rollover.max_primary_shard_size) {
      const maxPrimaryShardSize = (0, _policies.splitSizeAndUnits)(result.phases.hot.actions.rollover.max_primary_shard_size);
      result.phases.hot.actions.rollover.max_primary_shard_size = maxPrimaryShardSize.size;
      result._meta.hot.customRollover.maxPrimaryShardSizeUnit = maxPrimaryShardSize.units;
    }
    if (result.phases.hot.actions.rollover.max_age) {
      const maxAge = (0, _policies.splitSizeAndUnits)(result.phases.hot.actions.rollover.max_age);
      result.phases.hot.actions.rollover.max_age = maxAge.size;
      result._meta.hot.customRollover.maxAgeUnit = maxAge.units;
    }
  }
  if ((_result$phases$hot2 = result.phases.hot) !== null && _result$phases$hot2 !== void 0 && (_result$phases$hot2$a = _result$phases$hot2.actions.shrink) !== null && _result$phases$hot2$a !== void 0 && _result$phases$hot2$a.max_primary_shard_size) {
    const primaryShardSize = (0, _policies.splitSizeAndUnits)(result.phases.hot.actions.shrink.max_primary_shard_size);
    result.phases.hot.actions.shrink.max_primary_shard_size = primaryShardSize.size;
    result._meta.hot.shrink.maxPrimaryShardSizeUnits = primaryShardSize.units;
  }
  if ((_result$phases$hot3 = result.phases.hot) !== null && _result$phases$hot3 !== void 0 && (_result$phases$hot3$a = _result$phases$hot3.actions.downsample) !== null && _result$phases$hot3$a !== void 0 && _result$phases$hot3$a.fixed_interval) {
    const downsampleInterval = (0, _policies.splitSizeAndUnits)(result.phases.hot.actions.downsample.fixed_interval);
    result._meta.hot.downsample.fixedIntervalUnits = downsampleInterval.units;
    result._meta.hot.downsample.fixedIntervalSize = downsampleInterval.size;
  }
  if (result.phases.warm) {
    var _result$phases$warm$a, _result$phases$warm$a2, _result$phases$warm$a3, _result$phases$warm, _result$phases$warm$a4;
    if ((_result$phases$warm$a = result.phases.warm.actions) !== null && _result$phases$warm$a !== void 0 && (_result$phases$warm$a2 = _result$phases$warm$a.allocate) !== null && _result$phases$warm$a2 !== void 0 && _result$phases$warm$a2.require) {
      Object.entries(result.phases.warm.actions.allocate.require).forEach(entry => {
        result._meta.warm.allocationNodeAttribute = entry.join(':');
      });
    }
    if (result.phases.warm.min_age) {
      const minAge = (0, _policies.splitSizeAndUnits)(result.phases.warm.min_age);
      result.phases.warm.min_age = minAge.size;
      result._meta.warm.minAgeUnit = minAge.units;
    }
    if ((_result$phases$warm$a3 = result.phases.warm.actions.shrink) !== null && _result$phases$warm$a3 !== void 0 && _result$phases$warm$a3.max_primary_shard_size) {
      const primaryShardSize = (0, _policies.splitSizeAndUnits)(result.phases.warm.actions.shrink.max_primary_shard_size);
      result.phases.warm.actions.shrink.max_primary_shard_size = primaryShardSize.size;
      result._meta.warm.shrink.maxPrimaryShardSizeUnits = primaryShardSize.units;
    }
    if ((_result$phases$warm = result.phases.warm) !== null && _result$phases$warm !== void 0 && (_result$phases$warm$a4 = _result$phases$warm.actions.downsample) !== null && _result$phases$warm$a4 !== void 0 && _result$phases$warm$a4.fixed_interval) {
      const downsampleInterval = (0, _policies.splitSizeAndUnits)(result.phases.warm.actions.downsample.fixed_interval);
      result._meta.warm.downsample.fixedIntervalUnits = downsampleInterval.units;
      result._meta.warm.downsample.fixedIntervalSize = downsampleInterval.size;
    }
  }
  if (result.phases.cold) {
    var _result$phases$cold$a, _result$phases$cold$a2, _result$phases$cold, _result$phases$cold$a3;
    if ((_result$phases$cold$a = result.phases.cold.actions) !== null && _result$phases$cold$a !== void 0 && (_result$phases$cold$a2 = _result$phases$cold$a.allocate) !== null && _result$phases$cold$a2 !== void 0 && _result$phases$cold$a2.require) {
      Object.entries(result.phases.cold.actions.allocate.require).forEach(entry => {
        result._meta.cold.allocationNodeAttribute = entry.join(':');
      });
    }
    if (result.phases.cold.min_age) {
      const minAge = (0, _policies.splitSizeAndUnits)(result.phases.cold.min_age);
      result.phases.cold.min_age = minAge.size;
      result._meta.cold.minAgeUnit = minAge.units;
    }
    if ((_result$phases$cold = result.phases.cold) !== null && _result$phases$cold !== void 0 && (_result$phases$cold$a3 = _result$phases$cold.actions.downsample) !== null && _result$phases$cold$a3 !== void 0 && _result$phases$cold$a3.fixed_interval) {
      const downsampleInterval = (0, _policies.splitSizeAndUnits)(result.phases.cold.actions.downsample.fixed_interval);
      result._meta.cold.downsample.fixedIntervalUnits = downsampleInterval.units;
      result._meta.cold.downsample.fixedIntervalSize = downsampleInterval.size;
    }
  }
  if (result.phases.frozen) {
    if (result.phases.frozen.min_age) {
      const minAge = (0, _policies.splitSizeAndUnits)(result.phases.frozen.min_age);
      result.phases.frozen.min_age = minAge.size;
      result._meta.frozen.minAgeUnit = minAge.units;
    }
  }
  if (result.phases.delete) {
    if (result.phases.delete.min_age) {
      const minAge = (0, _policies.splitSizeAndUnits)(result.phases.delete.min_age);
      result.phases.delete.min_age = minAge.size;
      result._meta.delete.minAgeUnit = minAge.units;
    }
  }
  return result;
};
exports.createDeserializer = createDeserializer;