"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmBulkRollbackModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/confirm_bulk_rollback_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmBulkRollbackModal = ({
  onClose,
  onConfirm,
  selectedItems
}) => {
  var _selectedItems$0$inst;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isSingleItem = selectedItems.length === 1;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: isSingleItem ? _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkRollbackModal.singleTitle', {
      defaultMessage: 'Rollback {integrationName} to version {previousVersion}',
      values: {
        integrationName: selectedItems[0].title,
        previousVersion: (_selectedItems$0$inst = selectedItems[0].installationInfo) === null || _selectedItems$0$inst === void 0 ? void 0 : _selectedItems$0$inst.previous_version
      }
    }) : _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkRollbackModal.title', {
      defaultMessage: 'Rollback {countIntegrations} integrations ',
      values: {
        countIntegrations: selectedItems.length
      }
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkRollbackModal.confirmButton', {
      defaultMessage: 'Rollback {itemsCount, plural, one {integration} other {integrations}} ',
      values: {
        itemsCount: selectedItems.length
      }
    }),
    buttonColor: "primary",
    cancelButtonText: isSingleItem ? _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkRollbackModal.cancelSingleButton', {
      defaultMessage: 'Cancel'
    }) : _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkRollbackModal.cancelButton', {
      defaultMessage: 'Review and edit selection'
    }),
    onCancel: onClose,
    isLoading: isLoading,
    onConfirm: async () => {
      try {
        setIsLoading(true);
        await onConfirm();
        onClose();
      } catch (err) {
        setIsLoading(false);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "info",
    title: _i18n.i18n.translate('xpack.fleet.installedIntegrations.bulkRollbackModal.calloutTitle', {
      defaultMessage: 'This action impacts all integration policies and assets.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, isSingleItem ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkRollbackModal.calloutContentSingleItem",
    defaultMessage: "The integration will be rolled back to the previous version including assets and integration policies. Agents using the integration will receive the policy change.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.installedIntegrations.bulkRollbackModal.calloutContent",
    defaultMessage: "All integrations will be rolled back to the previous version including assets and integration policies. Agents using the integrations will receive the policy change.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })));
};
exports.ConfirmBulkRollbackModal = ConfirmBulkRollbackModal;