"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentMigrateFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../hooks");
var _headers_input = require("./headers_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/migrate_agent_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentMigrateFlyout = ({
  agents,
  agentCount,
  onClose,
  onSave,
  unsupportedMigrateAgents
}) => {
  var _formContent$settings, _formContent$settings2, _formContent$settings3, _formContent$settings4, _formContent$settings5, _formContent$settings6;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const migrateAgent = _hooks.sendMigrateSingleAgent;
  const migrateAgents = _hooks.sendBulkMigrateAgents;
  const [formValid, setFormValid] = _react.default.useState(false);
  const [validClusterURL, setValidClusterURL] = _react.default.useState(false);
  const [formContent, setFormContent] = _react.default.useState({
    id: '',
    agents: [],
    uri: '',
    enrollment_token: '',
    settings: {}
  });
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const filteredAgents = (0, _react.useMemo)(() => Array.isArray(agents) ? agents.filter(agent => !unsupportedMigrateAgents.some(a => a.id === agent.id)) : agents, [agents, unsupportedMigrateAgents]);
  const filteredAgentCount = (0, _react.useMemo)(() => Array.isArray(filteredAgents) ? filteredAgents.length : agentCount, [agentCount, filteredAgents]);
  (0, _react.useEffect)(() => {
    const validateForm = () => {
      const hasValidAgents = !Array.isArray(filteredAgents) || filteredAgents.length > 0;
      if (formContent.uri && formContent.enrollment_token && validClusterURL && hasValidAgents) {
        setFormValid(true);
      } else {
        setFormValid(false);
      }
    };
    const validateClusterURL = () => {
      if (formContent.uri) {
        // check that the uri matches a valid URI schema using URL constructor
        try {
          new URL(formContent.uri);
          setValidClusterURL(true);
        } catch (e) {
          setValidClusterURL(false);
        }
      } else {
        setValidClusterURL(false);
      }
    };
    validateClusterURL();
    validateForm();
  }, [formContent, validClusterURL, filteredAgents]);
  const submitForm = async () => {
    try {
      if (Array.isArray(filteredAgents)) {
        if (filteredAgents.length === 1) {
          await migrateAgent({
            ...formContent,
            id: filteredAgents[0].id
          });
        } else {
          await migrateAgents({
            ...formContent,
            agents: filteredAgents.map(agent => agent.id)
          });
        }
      } else {
        // agents is a query string
        await migrateAgents({
          ...formContent,
          agents: filteredAgents
        });
      }
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.successNotificationTitle', {
          defaultMessage: 'Agent migration initiated'
        }),
        text: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.successNotificationDescription', {
          defaultMessage: 'The agent migration process has been successfully initiated.'
        })
      });
      onSave();
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.errorNotificationTitle', {
          // defaultMessage: 'Failed to migrate agents',
          defaultMessage: 'Failed to migrate {agentCount, plural, one {agent} other {agents}}',
          values: {
            agentCount: filteredAgentCount
          }
        }),
        toastMessage: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.errorNotificationDescription', {
          defaultMessage: 'The agent migration process has failed.'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "migrateAgentFlyout",
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.title",
    defaultMessage: "Migrate {agentCount, plural, one {agent} other {agents}}",
    values: {
      agentCount: filteredAgentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.title",
    defaultMessage: "Move {agentCount, plural, one {this agent} other {these agents}} to a different Fleet Server by specifying a new cluster URL and enrollment token.",
    values: {
      agentCount: filteredAgentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  })), Array.isArray(agents) && unsupportedMigrateAgents.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "warning",
    "data-test-subj": "migrateAgentFlyoutAlertPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "warning",
    className: "eui-alignMiddle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.warning",
    defaultMessage: "{icon} {x} of {y} selected agents cannot be migrated as they are either tamper-protected agents, Fleet Server agents, containerized agents, or agents on an unsupported version.",
    values: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 29
        }
      }),
      x: unsupportedMigrateAgents.length,
      y: agentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "migrateAgentFlyoutWarningAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {},
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.warningAccordion",
      defaultMessage: "View Hosts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 23
      }
    })),
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 21
    }
  }, unsupportedMigrateAgents.map(agent => {
    var _agent$local_metadata, _agent$local_metadata2;
    return /*#__PURE__*/_react.default.createElement("li", {
      key: agent.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 25
      }
    }, (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.host) === null || _agent$local_metadata2 === void 0 ? void 0 : _agent$local_metadata2.hostname);
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.clusterUrlLabel",
      defaultMessage: "Remote Cluster URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 17
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.clusterUrlHelpText",
      defaultMessage: "Enter the URL of the Fleet server in the target cluster you want the agent to migrate to",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 17
      }
    }),
    isInvalid: !validClusterURL && formContent.uri !== '',
    error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.clusterUrlError",
      defaultMessage: "Invalid cluster URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !validClusterURL && formContent.uri !== '',
    placeholder: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.clusterUrlPlaceholder', {
      defaultMessage: 'Enter a valid cluster URL'
    }),
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      uri: e.target.value
    }),
    "data-test-subj": "migrateAgentFlyoutClusterUrlInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenLabel",
      defaultMessage: "Enrollment Token",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 17
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenHelpText",
      defaultMessage: "Enter a valid enrollment token generated in the target cluster",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    "data-test-subj": "migrateAgentFlyoutEnrollmentTokenInput",
    onChange: e => setFormContent({
      ...formContent,
      enrollment_token: e.target.value
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenPlaceholder', {
      defaultMessage: 'Enter a valid enrollment token'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    arrowDisplay: "left",
    id: "migrateAgentFlyoutAdditionalOptions",
    initialIsOpen: false,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.additionalOptionsLabel",
      defaultMessage: "Advanced options",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "tlsCertsSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.tlsCertsLabel",
      defaultMessage: "TLS & Certs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.tlsCertsDescriptionLabel",
    defaultMessage: "Provide optional TLS settings if your target Fleet server uses custom certificates.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "ca_sha256",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        ca_sha256: e.target.value
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.certAuthLabel",
      defaultMessage: "Certificate Authorities",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        certificate_authorities: e.target.value
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertLabel",
      defaultMessage: "Elastic Agent Certificate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        elastic_agent_cert: e.target.value
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertKeyLabel",
      defaultMessage: "Elastic Agent Certificate Key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        elastic_agent_cert_key: e.target.value
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "headersSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.headersMainLabel",
      defaultMessage: "Headers",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 433,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.headersDescriptionLabel",
    defaultMessage: "Custom HTTP headers sent during agent enrollment.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.headersLabel",
      defaultMessage: "Headers",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 449,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_headers_input.HeadersInput, {
    headers: ((_formContent$settings = formContent.settings) === null || _formContent$settings === void 0 ? void 0 : _formContent$settings.headers) || {},
    onUpdate: headers => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        headers
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.proxyHeadersLabel",
      defaultMessage: "Proxy Headers",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 471,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_headers_input.HeadersInput, {
    headers: ((_formContent$settings2 = formContent.settings) === null || _formContent$settings2 === void 0 ? void 0 : _formContent$settings2.proxy_headers) || {},
    onUpdate: headers => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        proxy_headers: headers
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "networkingSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 498,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.networkingLabel",
      defaultMessage: "Networking",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 499,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.networkingDescriptionLabel",
    defaultMessage: "Configure proxy settings if your network requires routing traffic through a proxy server.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 512,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.proxyUrlLabel",
      defaultMessage: "Proxy URL",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 515,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 513,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        proxy_url: e.target.value
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 522,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 534,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "headersSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 540,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.agentOptionsLabel",
      defaultMessage: "Agent Options",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 541,
        columnNumber: 25
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 536,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.agentOptionsDescriptionLabel",
    defaultMessage: "Customize behavior during migration. Control connection handling, staging environments, and token replacement logic.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 554,
      columnNumber: 21
    }
  }), agents.length === 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.replaceTokenLabel",
      defaultMessage: "Replace token",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 558,
        columnNumber: 27
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    "data-test-subj": "migrateAgentFlyoutReplaceTokenInput",
    onChange: e => {
      if ('id' in formContent) {
        setFormContent({
          ...formContent,
          settings: {
            ...formContent.settings,
            replace_token: e.target.value
          }
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 565,
      columnNumber: 25
    }
  })), agents.length === 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 45
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.stagingLabel",
      defaultMessage: "Staging",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 587,
        columnNumber: 25
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        staging: e.target.value
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 594,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 604,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 606,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 607,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 608,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.insecurelabel",
      defaultMessage: "Insecure",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 611,
        columnNumber: 31
      }
    }),
    checked: (_formContent$settings3 = (_formContent$settings4 = formContent.settings) === null || _formContent$settings4 === void 0 ? void 0 : _formContent$settings4.insecure) !== null && _formContent$settings3 !== void 0 ? _formContent$settings3 : false,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        insecure: e.target.checked
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 609,
      columnNumber: 27
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 627,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 629,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.proxyLabel",
      defaultMessage: "Proxy Disabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 632,
        columnNumber: 31
      }
    }),
    checked: (_formContent$settings5 = (_formContent$settings6 = formContent.settings) === null || _formContent$settings6 === void 0 ? void 0 : _formContent$settings6.proxy_disabled) !== null && _formContent$settings5 !== void 0 ? _formContent$settings5 : false,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        proxy_disabled: e.target.checked
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 630,
      columnNumber: 27
    }
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 657,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 658,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "migrateAgentFlyoutCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 659,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 660,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !formValid,
    onClick: submitForm,
    fill: true,
    "data-test-subj": "migrateAgentFlyoutSubmitButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 665,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.submitButtonLabel",
    defaultMessage: "Migrate {agentCount, plural, one {# agent} other {# agents}}",
    values: {
      agentCount: filteredAgentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 671,
      columnNumber: 15
    }
  }))))));
};
exports.AgentMigrateFlyout = AgentMigrateFlyout;