"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enrichFieldsWithECSInfo = enrichFieldsWithECSInfo;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const removeKeywordSuffix = name => {
  return name.endsWith('.keyword') ? name.slice(0, -8) : name;
};
/**
 * Returns columns with the metadata/description (e.g ECS info)
 * if available
 *
 * @param columns
 * @param fieldsMetadata
 * @returns
 */
function enrichFieldsWithECSInfo(columns, ecsMetadataCache) {
  if (!ecsMetadataCache) return columns;
  try {
    if (ecsMetadataCache) {
      return columns.map(c => {
        // Metadata services gives description for
        // 'ecs.version' but not 'ecs.version.keyword'
        // but both should show description if available
        const metadata = ecsMetadataCache[removeKeywordSuffix(c.name)];

        // Need to convert metadata's type (e.g. keyword) to ES|QL type (e.g. string) to check if they are the same
        if (!metadata || metadata !== null && metadata !== void 0 && metadata.type && metadata.type !== c.type) return c;
        return {
          ...c,
          isEcs: true
        };
      });
    }
    return columns;
  } catch (error) {
    // eslint-disable-next-line no-console
    console.error('Unable to fetch field metadata', error);
  }
  return columns;
}