"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Location = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// This is a subset of the Monaco's editor CompletitionItemKind type
// TODO consider not exporting this
// TODO consider not exporting this
/**
 * This is a list of locations within an ES|QL query.
 *
 * It is currently used to suggest appropriate functions and
 * operators given the location of the cursor.
 */
let Location = exports.Location = /*#__PURE__*/function (Location) {
  Location["EVAL"] = "eval";
  Location["WHERE"] = "where";
  Location["ROW"] = "row";
  Location["SORT"] = "sort";
  Location["STATS"] = "stats";
  Location["STATS_BY"] = "stats_by";
  Location["STATS_WHERE"] = "stats_where";
  Location["STATS_TIMESERIES"] = "stats_timeseries";
  Location["ENRICH"] = "enrich";
  Location["ENRICH_WITH"] = "enrich_with";
  Location["DISSECT"] = "dissect";
  Location["RENAME"] = "rename";
  Location["RERANK"] = "rerank";
  Location["JOIN"] = "join";
  Location["SHOW"] = "show";
  Location["COMPLETION"] = "completion";
  return Location;
}({});