"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsConversationOwner = exports.getCurrentConversationOwner = exports.getConversationSharedState = exports.ConversationSharedState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ConversationSharedState = exports.ConversationSharedState = /*#__PURE__*/function (ConversationSharedState) {
  ConversationSharedState["SHARED"] = "shared";
  ConversationSharedState["RESTRICTED"] = "restricted";
  ConversationSharedState["PRIVATE"] = "private";
  return ConversationSharedState;
}({});
/**
 * Determines the shared state of a conversation based on the number of users.
 * - If there are no users, the conversation is considered "Shared".
 * - If there is one user, the conversation is "Private".
 * - If there are multiple users, the conversation is "Restricted".
 * @param conversation
 */
const getConversationSharedState = conversation => {
  var _conversation$users$l;
  if (!conversation || (conversation === null || conversation === void 0 ? void 0 : conversation.id) === '') {
    // while loading or initializing, conversation is not shared
    return ConversationSharedState.PRIVATE;
  }
  const conversationUsers = (_conversation$users$l = conversation === null || conversation === void 0 ? void 0 : conversation.users.length) !== null && _conversation$users$l !== void 0 ? _conversation$users$l : 1;
  switch (conversationUsers) {
    case 0:
      return ConversationSharedState.SHARED;
    case 1:
      // length is 1, default to private
      return ConversationSharedState.PRIVATE;
    default:
      // more than 1 user
      return ConversationSharedState.RESTRICTED;
  }
};
exports.getConversationSharedState = getConversationSharedState;
const getCurrentConversationOwner = conversation => {
  var _conversation$created;
  return (_conversation$created = conversation === null || conversation === void 0 ? void 0 : conversation.createdBy) !== null && _conversation$created !== void 0 ? _conversation$created :
  // no createdBy property indicates legacy conversation, where only user was the owner
  (conversation === null || conversation === void 0 ? void 0 : conversation.users.length) === 1 ? conversation === null || conversation === void 0 ? void 0 : conversation.users[0] : {};
};
/**
 * Checks if the current user is the owner of the conversation.
 * The owner is defined as the user who created the conversation or, in legacy conversations,
 * the only user in the conversation.
 * @param conversation
 * @param user
 */
exports.getCurrentConversationOwner = getCurrentConversationOwner;
const getIsConversationOwner = (conversation, user) => {
  if (user === undefined || Object.keys(user).length === 0 || conversation === undefined || (conversation === null || conversation === void 0 ? void 0 : conversation.id) === '') return true;
  const conversationUser = getCurrentConversationOwner(conversation);
  const hasMatchingId = !!(conversationUser !== null && conversationUser !== void 0 && conversationUser.id) && !!(user !== null && user !== void 0 && user.id) && (conversationUser === null || conversationUser === void 0 ? void 0 : conversationUser.id) === (user === null || user === void 0 ? void 0 : user.id);
  const hasMatchingName = !!(conversationUser !== null && conversationUser !== void 0 && conversationUser.name) && !!(user !== null && user !== void 0 && user.name) && (conversationUser === null || conversationUser === void 0 ? void 0 : conversationUser.name) === (user === null || user === void 0 ? void 0 : user.name);
  return hasMatchingId || hasMatchingName;
};
exports.getIsConversationOwner = getIsConversationOwner;