"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpandAction = getExpandAction;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getExpandAction({
  name,
  description,
  isExpanded,
  onClick,
  ...props
}) {
  return {
    name,
    description,
    type: 'icon',
    'data-test-subj': props['data-test-subj'],
    icon: value => isExpanded(value) ? 'arrowDown' : 'arrowRight',
    onClick: value => onClick(isExpanded(value) ? undefined : value)
  };
}