"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableWithoutPersist = exports.Table = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/source_filters_table/components/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const filterHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.filterHeader', {
  defaultMessage: 'Filter'
});
const filterDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.filterDescription', {
  defaultMessage: 'Filter name'
});
const matchesHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.matchesHeader', {
  defaultMessage: 'Matches'
});
const matchesDescription = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.matchesDescription', {
  defaultMessage: 'Language used for the field'
});
const editAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.editAria', {
  defaultMessage: 'Edit'
});
const saveAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.saveAria', {
  defaultMessage: 'Save'
});
const deleteAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.deleteAria', {
  defaultMessage: 'Delete'
});
const cancelAria = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.source.table.cancelAria', {
  defaultMessage: 'Cancel'
});
const PAGE_SIZE_OPTIONS = [5, 10, 25, 50];
class TableClass extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "startEditingFilter", (editingFilterId, editingFilterValue) => this.setState({
      editingFilterId,
      editingFilterValue
    }));
    (0, _defineProperty2.default)(this, "stopEditingFilter", () => this.setState({
      editingFilterId: ''
    }));
    (0, _defineProperty2.default)(this, "onEditingFilterChange", e => this.setState({
      editingFilterValue: e.target.value
    }));
    (0, _defineProperty2.default)(this, "onEditFieldKeyDown", ({
      key
    }) => {
      if (_eui.keys.ENTER === key && this.state.editingFilterId && this.state.editingFilterValue) {
        this.props.saveFilter({
          clientId: this.state.editingFilterId,
          value: this.state.editingFilterValue
        });
        this.stopEditingFilter();
      }
      if (_eui.keys.ESCAPE === key) {
        this.stopEditingFilter();
      }
    });
    this.state = {
      editingFilterId: '',
      editingFilterValue: ''
    };
  }
  getColumns() {
    const {
      deleteFilter,
      fieldWildcardMatcher,
      indexPattern,
      saveFilter
    } = this.props;
    return [{
      field: 'value',
      name: filterHeader,
      description: filterDescription,
      dataType: 'string',
      sortable: true,
      render: (value, filter) => {
        if (this.state.editingFilterId && this.state.editingFilterId === filter.clientId) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
            autoFocus: true,
            value: this.state.editingFilterValue,
            onChange: this.onEditingFilterChange,
            onKeyDown: this.onEditFieldKeyDown,
            "data-test-subj": `filter_input_${value}`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 134,
              columnNumber: 15
            }
          });
        }
        return /*#__PURE__*/_react.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 144,
            columnNumber: 18
          }
        }, value);
      }
    }, {
      field: 'value',
      name: matchesHeader,
      description: matchesDescription,
      dataType: 'string',
      sortable: true,
      render: (value, filter) => {
        const wildcardMatcher = fieldWildcardMatcher([this.state.editingFilterId === filter.clientId ? this.state.editingFilterValue : value]);
        const matches = indexPattern.getNonScriptedFields().map(currentFilter => currentFilter.name).filter(wildcardMatcher).sort();
        if (matches.length) {
          return /*#__PURE__*/_react.default.createElement("span", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 164,
              columnNumber: 20
            }
          }, matches.join(', '));
        }
        return /*#__PURE__*/_react.default.createElement("em", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternManagement.editIndexPattern.source.table.notMatchedLabel",
          defaultMessage: "The source filter doesn't match any known fields.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 15
          }
        }));
      }
    }, {
      name: '',
      align: _eui.RIGHT_ALIGNMENT,
      width: '100',
      render: filter => {
        if (this.state.editingFilterId === filter.clientId) {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            size: "s",
            onClick: () => {
              saveFilter({
                clientId: this.state.editingFilterId,
                value: this.state.editingFilterValue
              });
              this.stopEditingFilter();
            },
            iconType: "checkInCircleFilled",
            "aria-label": saveAria,
            "data-test-subj": `save_filter-${filter.value}`,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 185,
              columnNumber: 17
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            size: "s",
            onClick: () => {
              this.stopEditingFilter();
            },
            iconType: "cross",
            "aria-label": cancelAria,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 198,
              columnNumber: 17
            }
          }));
        }
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          size: "s",
          onClick: () => this.startEditingFilter(filter.clientId, filter.value),
          iconType: "pencil",
          "aria-label": editAria,
          "data-test-subj": `edit_filter-${filter.value}`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          size: "s",
          color: "danger",
          onClick: () => deleteFilter(filter),
          iconType: "trash",
          "aria-label": deleteAria,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 219,
            columnNumber: 15
          }
        }));
      }
    }];
  }
  render() {
    const {
      items,
      isSaving,
      euiTablePersist: {
        pageSize,
        sorting,
        onTableChange
      }
    } = this.props;
    const columns = this.getColumns();
    const pagination = {
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      loading: isSaving,
      items: items,
      columns: columns,
      pagination: pagination,
      sorting: sorting,
      onTableChange: onTableChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 7
      }
    });
  }
}
const TableWithoutPersist = exports.TableWithoutPersist = TableClass; // For testing purposes

const Table = exports.Table = (0, _sharedUxTablePersist.withEuiTablePersist)(TableClass, {
  tableId: 'dataViewsSourceFilters',
  pageSizeOptions: PAGE_SIZE_OPTIONS,
  initialPageSize: 10
});