"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutPanelsContext = exports.Panels = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/flyout_panels/flyout_panels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let idx = 0;
const panelId = () => idx++;
const flyoutPanelsContext = /*#__PURE__*/(0, _react.createContext)({
  addPanel() {
    return {
      removePanel: () => {},
      isFixedWidth: false
    };
  }
});
const limitWidthToWindow = (width, {
  innerWidth
}) => Math.min(width, innerWidth * 0.8);
const Panels = ({
  maxWidth,
  flyoutClassName,
  fixedPanelWidths = false,
  ...props
}) => {
  const flyoutDOMelement = (0, _react.useMemo)(() => {
    const el = document.getElementsByClassName(flyoutClassName);
    if (el.length === 0) {
      return null;
    }
    return el.item(0);
  }, [flyoutClassName]);
  const [panels, setPanels] = (0, _react.useState)({});
  const removePanel = (0, _react.useCallback)(id => {
    setPanels(prev => {
      const {
        [id]: panelToRemove,
        ...rest
      } = prev;
      return rest;
    });
  }, []);
  const addPanel = (0, _react.useCallback)(panel => {
    const nextId = panelId();
    setPanels(prev => {
      return {
        ...prev,
        [nextId]: panel
      };
    });
    return {
      removePanel: removePanel.bind(null, nextId),
      isFixedWidth: fixedPanelWidths
    };
  }, [removePanel, fixedPanelWidths]);
  const ctx = (0, _react.useMemo)(() => ({
    addPanel
  }), [addPanel]);
  (0, _react.useLayoutEffect)(() => {
    if (!flyoutDOMelement) {
      return;
    }
    let currentWidth;
    if (typeof maxWidth === 'number') {
      if (fixedPanelWidths) {
        const totalWidth = Object.values(panels).reduce((acc, {
          width = 0
        }) => acc + width, 0);
        currentWidth = Math.min(maxWidth, totalWidth);
        // As EUI declares both min-width and max-width on the .euiFlyout CSS class
        // we need to override  both values
        flyoutDOMelement.style.minWidth = `${limitWidthToWindow(currentWidth, window)}px`;
        flyoutDOMelement.style.maxWidth = `${limitWidthToWindow(currentWidth, window)}px`;
      } else {
        const totalPercentWidth = Math.min(100, Object.values(panels).reduce((acc, {
          width = 0
        }) => acc + width, 0));
        currentWidth = maxWidth * totalPercentWidth / 100;
        flyoutDOMelement.style.maxWidth = `${limitWidthToWindow(currentWidth, window)}px`;
      }
    } else {
      // maxWidth is false on smaller mobile screens when the preview panel is unused.
      // Unset custom min/max widths and let EUI's default 90vw width be used
      flyoutDOMelement.style.minWidth = '';
      flyoutDOMelement.style.maxWidth = '';
    }
  }, [panels, maxWidth, fixedPanelWidths, flyoutClassName, flyoutDOMelement]);
  return /*#__PURE__*/_react.default.createElement(flyoutPanelsContext.Provider, {
    value: ctx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    css: styles.flyoutPanels,
    gutterSize: "none"
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  })));
};
exports.Panels = Panels;
const useFlyoutPanelsContext = () => {
  const ctx = (0, _react.useContext)(flyoutPanelsContext);
  if (ctx === undefined) {
    throw new Error('<Panel /> must be used within a <Panels /> wrapper');
  }
  return ctx;
};
exports.useFlyoutPanelsContext = useFlyoutPanelsContext;
const styles = {
  flyoutPanels: (0, _react2.css)({
    height: '100%'
  })
};