"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeESQLControlSelections = initializeESQLControlSelections;
exports.selectionComparators = void 0;
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
var _esqlTypes = require("@kbn/esql-types");
var _kibana_services = require("../../services/kibana_services");
var _get_esql_single_column_values = require("./utils/get_esql_single_column_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function selectedOptionsComparatorFunction(a, b) {
  return (0, _reactFastCompare.default)(a !== null && a !== void 0 ? a : [], b !== null && b !== void 0 ? b : []);
}
const selectionComparators = exports.selectionComparators = {
  selectedOptions: selectedOptionsComparatorFunction,
  availableOptions: (a, b, lastState, currentState) => {
    // Only compare availableOptions for static values controls; values from query fetch these at runtime
    if ((lastState === null || lastState === void 0 ? void 0 : lastState.controlType) === (currentState === null || currentState === void 0 ? void 0 : currentState.controlType) && (currentState === null || currentState === void 0 ? void 0 : currentState.controlType) === _esqlTypes.EsqlControlType.VALUES_FROM_QUERY) {
      return true;
    }
    return (0, _reactFastCompare.default)(a !== null && a !== void 0 ? a : [], b !== null && b !== void 0 ? b : []);
  },
  variableName: 'referenceEquality',
  variableType: 'referenceEquality',
  controlType: 'referenceEquality',
  esqlQuery: 'referenceEquality',
  title: 'referenceEquality'
};
function initializeESQLControlSelections(initialState, controlFetch$, setDataLoading) {
  var _initialState$availab, _initialState$selecte, _initialState$variabl, _initialState$variabl2, _initialState$control, _initialState$esqlQue, _initialState$availab2, _initialState$availab3, _initialState$availab4, _initialState$availab5;
  const availableOptions$ = new _rxjs.BehaviorSubject((_initialState$availab = initialState.availableOptions) !== null && _initialState$availab !== void 0 ? _initialState$availab : []);
  const selectedOptions$ = new _rxjs.BehaviorSubject((_initialState$selecte = initialState.selectedOptions) !== null && _initialState$selecte !== void 0 ? _initialState$selecte : []);
  const hasSelections$ = new _rxjs.BehaviorSubject(false); // hardcoded to false to prevent clear action from appearing.
  const variableName$ = new _rxjs.BehaviorSubject((_initialState$variabl = initialState.variableName) !== null && _initialState$variabl !== void 0 ? _initialState$variabl : '');
  const variableType$ = new _rxjs.BehaviorSubject((_initialState$variabl2 = initialState.variableType) !== null && _initialState$variabl2 !== void 0 ? _initialState$variabl2 : _esqlTypes.ESQLVariableType.VALUES);
  const controlType$ = new _rxjs.BehaviorSubject((_initialState$control = initialState.controlType) !== null && _initialState$control !== void 0 ? _initialState$control : '');
  const esqlQuery$ = new _rxjs.BehaviorSubject((_initialState$esqlQue = initialState.esqlQuery) !== null && _initialState$esqlQue !== void 0 ? _initialState$esqlQue : '');
  const title$ = new _rxjs.BehaviorSubject(initialState.title);
  const totalCardinality$ = new _rxjs.BehaviorSubject((_initialState$availab2 = (_initialState$availab3 = initialState.availableOptions) === null || _initialState$availab3 === void 0 ? void 0 : _initialState$availab3.length) !== null && _initialState$availab2 !== void 0 ? _initialState$availab2 : 0);
  const searchString$ = new _rxjs.BehaviorSubject('');
  const displayedAvailableOptions$ = new _rxjs.BehaviorSubject((_initialState$availab4 = (_initialState$availab5 = initialState.availableOptions) === null || _initialState$availab5 === void 0 ? void 0 : _initialState$availab5.map(value => ({
    value
  }))) !== null && _initialState$availab4 !== void 0 ? _initialState$availab4 : []);
  function setSearchString(next) {
    searchString$.next(next);
  }
  function setSelectedOptions(next) {
    if (!next) return;
    const selected = next;
    if (!selectedOptionsComparatorFunction(selectedOptions$.value, selected)) {
      selectedOptions$.next(selected);
    }
  }

  // For Values From Query controls, update values on dashboard load/reload
  const fetchSubscription = controlFetch$.pipe((0, _rxjs.filter)(() => controlType$.getValue() === _esqlTypes.EsqlControlType.VALUES_FROM_QUERY), (0, _rxjs.switchMap)(async ({
    timeRange
  }) => {
    setDataLoading(true);
    return await (0, _get_esql_single_column_values.getESQLSingleColumnValues)({
      query: esqlQuery$.getValue(),
      search: _kibana_services.dataService.search.search,
      timeRange
    });
  })).subscribe(result => {
    setDataLoading(false);
    if (_get_esql_single_column_values.getESQLSingleColumnValues.isSuccess(result)) {
      availableOptions$.next(result.values.map(value => value));
    }
  });

  // Filter the displayed available options by the current search string
  // TODO: Run this filtering server-side instead of client side; this just replicates the basic behavior
  // of a combo box dropdown for keyboard accessibility
  const availableOptionsSearchSubscription = (0, _rxjs.combineLatest)([searchString$, availableOptions$]).pipe((0, _rxjs.debounceTime)(50)).subscribe(([searchString, availableOptions]) => {
    var _availableOptions$fil;
    const displayOptions = (_availableOptions$fil = availableOptions === null || availableOptions === void 0 ? void 0 : availableOptions.filter(option => option.includes(searchString))) !== null && _availableOptions$fil !== void 0 ? _availableOptions$fil : [];
    displayedAvailableOptions$.next(displayOptions.map(value => ({
      value
    })));
    totalCardinality$.next(displayOptions.length);
  });

  // derive ESQL control variable from state.
  const getEsqlVariable = () => ({
    key: variableName$.value,
    value: isNaN(Number(selectedOptions$.value[0])) ? selectedOptions$.value[0] : Number(selectedOptions$.value[0]),
    type: variableType$.value
  });
  const esqlVariable$ = new _rxjs.BehaviorSubject(getEsqlVariable());
  const variableSubscriptions = (0, _rxjs.combineLatest)([variableName$, variableType$, selectedOptions$, availableOptions$]).subscribe(() => esqlVariable$.next(getEsqlVariable()));
  return {
    cleanup: () => {
      variableSubscriptions.unsubscribe();
      fetchSubscription.unsubscribe();
      availableOptionsSearchSubscription.unsubscribe();
    },
    api: {
      hasSelections$: hasSelections$,
      esqlVariable$: esqlVariable$
    },
    anyStateChange$: (0, _rxjs.merge)(selectedOptions$, availableOptions$, variableName$, variableType$, controlType$, esqlQuery$, title$).pipe((0, _rxjs.map)(() => undefined)),
    reinitializeState: lastSaved => {
      var _lastSaved$selectedOp, _lastSaved$availableO, _lastSaved$variableNa, _lastSaved$variableTy, _lastSaved$esqlQuery;
      setSelectedOptions((_lastSaved$selectedOp = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.selectedOptions) !== null && _lastSaved$selectedOp !== void 0 ? _lastSaved$selectedOp : []);
      availableOptions$.next((_lastSaved$availableO = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.availableOptions) !== null && _lastSaved$availableO !== void 0 ? _lastSaved$availableO : []);
      variableName$.next((_lastSaved$variableNa = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.variableName) !== null && _lastSaved$variableNa !== void 0 ? _lastSaved$variableNa : '');
      variableType$.next((_lastSaved$variableTy = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.variableType) !== null && _lastSaved$variableTy !== void 0 ? _lastSaved$variableTy : _esqlTypes.ESQLVariableType.VALUES);
      if (lastSaved !== null && lastSaved !== void 0 && lastSaved.controlType) controlType$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.controlType);
      esqlQuery$.next((_lastSaved$esqlQuery = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.esqlQuery) !== null && _lastSaved$esqlQuery !== void 0 ? _lastSaved$esqlQuery : '');
      title$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.title);
    },
    getLatestState: () => {
      var _selectedOptions$$get, _availableOptions$$ge, _variableName$$getVal, _variableType$$getVal, _esqlQuery$$getValue, _title$$getValue;
      return {
        selectedOptions: (_selectedOptions$$get = selectedOptions$.getValue()) !== null && _selectedOptions$$get !== void 0 ? _selectedOptions$$get : [],
        ...(controlType$.getValue() === _esqlTypes.EsqlControlType.STATIC_VALUES ? {
          availableOptions: (_availableOptions$$ge = availableOptions$.getValue()) !== null && _availableOptions$$ge !== void 0 ? _availableOptions$$ge : []
        } : {}),
        variableName: (_variableName$$getVal = variableName$.getValue()) !== null && _variableName$$getVal !== void 0 ? _variableName$$getVal : '',
        variableType: (_variableType$$getVal = variableType$.getValue()) !== null && _variableType$$getVal !== void 0 ? _variableType$$getVal : _esqlTypes.ESQLVariableType.VALUES,
        controlType: controlType$.getValue(),
        esqlQuery: (_esqlQuery$$getValue = esqlQuery$.getValue()) !== null && _esqlQuery$$getValue !== void 0 ? _esqlQuery$$getValue : '',
        title: (_title$$getValue = title$.getValue()) !== null && _title$$getValue !== void 0 ? _title$$getValue : ''
      };
    },
    internalApi: {
      selectedOptions$: selectedOptions$,
      availableOptions$: displayedAvailableOptions$,
      totalCardinality$,
      title$,
      setSelectedOptions,
      setSearchString,
      field$: new _rxjs.BehaviorSubject({
        type: 'string'
      }),
      searchTechnique$: new _rxjs.BehaviorSubject('wildcard'),
      searchString$,
      searchStringValid$: new _rxjs.BehaviorSubject(true)
    }
  };
}