"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getV2 = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server = require("@kbn/core/server");
var _constants = require("../../common/constants");
var _common = require("../../common");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The order of appearance in the feature privilege page
 * under the management section. Cases should be under
 * the Actions and Connectors feature
 */

const FEATURE_ORDER = 3100;
const getV2 = () => {
  const capabilities = (0, _common.createUICapabilities)();
  const apiTags = (0, _common.getApiTags)(_constants.APP_ID);
  return {
    deprecated: {
      notice: _i18n.i18n.translate('xpack.cases.features.casesFeatureV2.deprecationMessage', {
        defaultMessage: 'The {currentId} permissions are deprecated, please see {casesFeatureIdV3}.',
        values: {
          currentId: _constants.FEATURE_ID_V2,
          casesFeatureIdV3: _constants.FEATURE_ID_V3
        }
      })
    },
    id: _constants.FEATURE_ID_V2,
    name: _i18n.i18n.translate('xpack.cases.features.casesFeatureName', {
      defaultMessage: 'Cases'
    }),
    category: _server.DEFAULT_APP_CATEGORIES.management,
    app: [],
    order: FEATURE_ORDER,
    management: {
      insightsAndAlerting: [_constants.APP_ID]
    },
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: apiTags.all,
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID],
          assign: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: [...capabilities.all, ...capabilities.assignCase],
        replacedBy: {
          default: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['all']
          }],
          minimal: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['minimal_all', 'cases_assign']
          }]
        }
      },
      read: {
        api: apiTags.read,
        cases: {
          read: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: capabilities.read,
        replacedBy: {
          default: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['read']
          }],
          minimal: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: ['minimal_read']
          }]
        }
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureName', {
        defaultMessage: 'Delete'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: apiTags.delete,
          id: _constants2.CASES_DELETE_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureDetails', {
            defaultMessage: 'Delete cases and comments'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            delete: [_constants.APP_ID]
          },
          ui: capabilities.delete,
          replacedBy: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: [_constants2.CASES_DELETE_SUB_PRIVILEGE_ID]
          }]
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureName', {
        defaultMessage: 'Case settings'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: _constants2.CASES_SETTINGS_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureDetails', {
            defaultMessage: 'Edit case settings'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            settings: [_constants.APP_ID]
          },
          ui: capabilities.settings,
          replacedBy: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: [_constants2.CASES_SETTINGS_SUB_PRIVILEGE_ID]
          }]
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.addCommentsSubFeatureName', {
        defaultMessage: 'Create comments & attachments'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: apiTags.createComment,
          id: _constants2.CASES_CREATE_COMMENT_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.addCommentsSubFeatureDetails', {
            defaultMessage: 'Add comments to cases'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            createComment: [_constants.APP_ID]
          },
          ui: capabilities.createComment,
          replacedBy: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: [_constants2.CASES_CREATE_COMMENT_SUB_PRIVILEGE_ID]
          }]
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.reopenCaseSubFeatureName', {
        defaultMessage: 'Re-open'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: _constants2.CASES_REOPEN_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.reopenCaseSubFeatureDetails', {
            defaultMessage: 'Re-open closed cases'
          }),
          includeIn: 'all',
          savedObject: {
            all: [],
            read: []
          },
          cases: {
            reopenCase: [_constants.APP_ID]
          },
          ui: capabilities.reopenCase,
          replacedBy: [{
            feature: _constants.FEATURE_ID_V3,
            privileges: [_constants2.CASES_REOPEN_SUB_PRIVILEGE_ID]
          }]
        }]
      }]
    }]
  };
};
exports.getV2 = getV2;