"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchFunctions = fetchFunctions;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fetchFunctions({
  profilingDataAccessStart,
  core,
  esClient,
  startIndex,
  endIndex,
  start,
  end,
  kuery,
  serviceName,
  transactionName,
  environment,
  transactionType,
  indices,
  stacktraceIdsField
}) {
  return profilingDataAccessStart.services.fetchFunctions({
    core,
    esClient,
    startIndex,
    endIndex,
    totalSeconds: end - start,
    indices,
    stacktraceIdsField,
    query: {
      bool: {
        filter: [...(0, _server.kqlQuery)(kuery), ...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), {
          range: {
            ['@timestamp']: {
              gte: String(start),
              lt: String(end),
              format: 'epoch_second'
            }
          }
        }]
      }
    }
  });
}