"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallContext = void 0;
exports.WaterfallContextProvider = WaterfallContextProvider;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _get_critical_path = require("../../../../../../../../common/critical_path/get_critical_path");
var _waterfall_helpers = require("../waterfall_helpers/waterfall_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/context/waterfall_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WaterfallContext = exports.WaterfallContext = /*#__PURE__*/_react.default.createContext({
  criticalPathSegmentsById: {},
  showCriticalPath: false,
  traceList: [],
  getErrorCount: () => 0,
  updateTreeNode: () => undefined,
  isEmbeddable: false
});
function WaterfallContextProvider({
  showCriticalPath,
  waterfall,
  maxLevelOpen,
  children,
  isOpen,
  isEmbeddable
}) {
  const [tree, setTree] = (0, _react.useState)(null);
  const criticalPathSegmentsById = (0, _react.useMemo)(() => {
    if (!showCriticalPath) {
      return {};
    }
    const criticalPath = (0, _get_critical_path.getCriticalPath)(waterfall);
    return (0, _lodash.groupBy)(criticalPath.segments, segment => segment.item.id);
  }, [showCriticalPath, waterfall]);
  const traceList = (0, _react.useMemo)(() => {
    return (0, _waterfall_helpers.convertTreeToList)(tree);
  }, [tree]);
  const getErrorCount = (0, _react.useCallback)(waterfallItemId => waterfall.getErrorCount(waterfallItemId), [waterfall]);
  const updateTreeNode = (0, _react.useCallback)(updatedNode => {
    if (!tree) return;
    const newTree = (0, _waterfall_helpers.updateTraceTreeNode)({
      root: tree,
      updatedNode,
      waterfall,
      path: {
        criticalPathSegmentsById,
        showCriticalPath
      }
    });
    if (newTree) {
      setTree(newTree);
    }
  }, [criticalPathSegmentsById, showCriticalPath, tree, waterfall]);
  (0, _react.useEffect)(() => {
    const root = (0, _waterfall_helpers.buildTraceTree)({
      waterfall,
      maxLevelOpen,
      isOpen,
      path: {
        criticalPathSegmentsById,
        showCriticalPath
      }
    });
    setTree(root);
  }, [criticalPathSegmentsById, isOpen, maxLevelOpen, showCriticalPath, waterfall]);
  return /*#__PURE__*/_react.default.createElement(WaterfallContext.Provider, {
    value: {
      showCriticalPath,
      criticalPathSegmentsById,
      getErrorCount,
      traceList,
      updateTreeNode,
      isEmbeddable
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }, children);
}