"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormControlLayoutDelimited = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _text = require("../../text");
var _eui_form_context = require("../eui_form_context");
var _form_control_layout = require("./form_control_layout");
var _form_control_layout_delimited = require("./form_control_layout_delimited.styles");
var _react2 = require("@emotion/react");
var _excluded = ["startControl", "endControl", "delimiter", "className", "fullWidth"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFormControlLayoutDelimited = exports.EuiFormControlLayoutDelimited = function EuiFormControlLayoutDelimited(_ref) {
  var _rest$wrapperProps;
  var startControl = _ref.startControl,
    endControl = _ref.endControl,
    delimiter = _ref.delimiter,
    className = _ref.className,
    _fullWidth = _ref.fullWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var isRefreshVariant = (0, _services.useEuiThemeRefreshVariant)('formVariant');
  var _useFormContext = (0, _eui_form_context.useFormContext)(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var fullWidth = _fullWidth !== null && _fullWidth !== void 0 ? _fullWidth : defaultFullWidth;
  var isInvalid = rest.isInvalid,
    isDisabled = rest.isDisabled,
    readOnly = rest.readOnly;
  var showInvalidState = isInvalid && !isDisabled && !readOnly;
  var classes = (0, _classnames.default)('euiFormControlLayoutDelimited', className, {
    'euiFormControlLayoutDelimited--isInvalid': showInvalidState
  });
  var styles = (0, _services.useEuiMemoizedStyles)(_form_control_layout_delimited.euiFormControlLayoutDelimitedStyles);
  var cssStyles = [styles.delimited, rest.isDisabled && styles.disabled, rest.readOnly && styles.readOnly];
  var wrapperStyles = [styles.childrenWrapper.delimited, showInvalidState && styles.childrenWrapper.invalid, (_rest$wrapperProps = rest.wrapperProps) === null || _rest$wrapperProps === void 0 ? void 0 : _rest$wrapperProps.css, isRefreshVariant && rest.readOnly && styles.childrenWrapper.readOnly];
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, _extends({
    isDelimited: true,
    css: cssStyles,
    className: classes,
    iconsPosition: "static",
    fullWidth: fullWidth
  }, rest, {
    wrapperProps: _objectSpread(_objectSpread({}, rest.wrapperProps), {}, {
      css: wrapperStyles
    })
  }), (0, _react2.jsx)(_eui_form_context.FormContext.Provider, {
    value: {
      defaultFullWidth: fullWidth
    }
  }, startControl && addClassesToControl(euiThemeContext, startControl), (0, _react2.jsx)(EuiFormControlDelimiter, {
    delimiter: delimiter,
    isInvalid: showInvalidState
  }), endControl && addClassesToControl(euiThemeContext, endControl)));
};
EuiFormControlLayoutDelimited.propTypes = {
  /**
       * Left side control
       */
  startControl: _propTypes.default.element,
  /**
       * Right side control
       */
  endControl: _propTypes.default.element,
  /**
       * The center content. Accepts a string to be wrapped in a subdued EuiText
       * or a single ReactElement
       */
  delimiter: _propTypes.default.node,
  className: _propTypes.default.string
};
var addClassesToControl = function addClassesToControl(euiThemeContext, control) {
  return (0, _services.cloneElementWithCss)(control, {
    css: (0, _form_control_layout_delimited.euiFormControlLayoutDelimited__input)(euiThemeContext),
    className: (0, _classnames.default)(control.props.className, 'euiFormControlLayoutDelimited__input')
  }, 'before');
};
var EuiFormControlDelimiter = function EuiFormControlDelimiter(_ref2) {
  var delimiter = _ref2.delimiter,
    isInvalid = _ref2.isInvalid;
  var euiThemeContext = (0, _services.useEuiTheme)();
  var defaultAriaLabel = (0, _i18n.useEuiI18n)('euiFormControlLayoutDelimited.delimiterLabel', 'to');
  return (0, _react2.jsx)(_text.EuiText, {
    css: (0, _form_control_layout_delimited.euiFormControlLayoutDelimited__delimiter)(euiThemeContext),
    className: "euiFormControlLayoutDelimited__delimiter",
    size: "s",
    color: isInvalid ? 'danger' : 'subdued'
  }, delimiter !== null && delimiter !== void 0 ? delimiter : (0, _react2.jsx)(_icon.EuiIcon, {
    type: "sortRight",
    "aria-label": defaultAriaLabel
  }));
};