"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsDataService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rule_migrations_data_client = require("./rule_migrations_data_client");
var _field_maps = require("./field_maps");
var _index_migrators = require("../index_migrators");
var _siem_migrations_base_service = require("../../common/siem_migrations_base_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationsDataService extends _siem_migrations_base_service.SiemMigrationsBaseDataService {
  constructor(logger, kibanaVersion, elserInferenceId) {
    super(kibanaVersion);
    (0, _defineProperty2.default)(this, "baseIndexName", '.kibana-siem-rule-migrations');
    (0, _defineProperty2.default)(this, "adapters", void 0);
    this.logger = logger;
    this.kibanaVersion = kibanaVersion;
    this.adapters = {
      migrations: this.createRuleIndexPatternAdapter({
        adapterId: 'migrations',
        fieldMap: _field_maps.migrationsFieldMaps
      }),
      rules: this.createRuleIndexPatternAdapter({
        adapterId: 'rules',
        fieldMap: _field_maps.ruleMigrationsFieldMap
      }),
      resources: this.createRuleIndexPatternAdapter({
        adapterId: 'resources',
        fieldMap: _field_maps.ruleMigrationResourcesFieldMap
      }),
      integrations: this.createRuleIndexAdapter({
        adapterId: 'integrations',
        fieldMap: (0, _field_maps.getIntegrationsFieldMap)({
          elserInferenceId
        })
      }),
      prebuiltrules: this.createRuleIndexAdapter({
        adapterId: 'prebuiltrules',
        fieldMap: (0, _field_maps.getPrebuiltRulesFieldMap)({
          elserInferenceId
        })
      })
    };
  }
  createRuleIndexPatternAdapter({
    adapterId,
    fieldMap
  }) {
    const name = this.getAdapterIndexName(adapterId);
    return this.createIndexPatternAdapter({
      name,
      fieldMap
    });
  }
  createRuleIndexAdapter({
    adapterId,
    fieldMap
  }) {
    const name = this.getAdapterIndexName(adapterId);
    return this.createIndexAdapter({
      name,
      fieldMap
    });
  }
  async runIndexMigrations(esClient) {
    const indexMigrator = new _index_migrators.RuleMigrationIndexMigrator(this.adapters, esClient, this.logger);
    await indexMigrator.run();
  }
  async install(params) {
    await Promise.all([this.adapters.rules.install({
      ...params,
      logger: this.logger
    }), this.adapters.resources.install({
      ...params,
      logger: this.logger
    }), this.adapters.integrations.install({
      ...params,
      logger: this.logger
    }), this.adapters.prebuiltrules.install({
      ...params,
      logger: this.logger
    }), this.adapters.migrations.install({
      ...params,
      logger: this.logger
    })]);
  }
  async setup(params) {
    await this.install(params);
    await this.runIndexMigrations(params.esClient);
  }
  createClient({
    spaceId,
    currentUser,
    esScopedClient,
    dependencies
  }) {
    const indexNameProviders = {
      rules: this.createIndexNameProvider(this.adapters.rules, spaceId),
      resources: this.createIndexNameProvider(this.adapters.resources, spaceId),
      integrations: async () => this.getAdapterIndexName('integrations'),
      prebuiltrules: async () => this.getAdapterIndexName('prebuiltrules'),
      migrations: this.createIndexNameProvider(this.adapters.migrations, spaceId)
    };
    return new _rule_migrations_data_client.RuleMigrationsDataClient(indexNameProviders, currentUser, esScopedClient, this.logger, spaceId, dependencies);
  }
}
exports.RuleMigrationsDataService = RuleMigrationsDataService;