"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryExistingUsers = void 0;
var _Either = require("fp-ts/Either");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryExistingUsers = (esClient, index) => batch => esClient.search({
  index,
  size: batch.length,
  query: {
    bool: {
      must: [{
        terms: {
          'user.name': Array.from(batch).filter(_Either.isRight).map(e => e.right.username)
        }
      }]
    }
  }
}).then(response => response.hits.hits.reduce((users, hit) => {
  var _hit$_source, _hit$_source$user;
  if (!((_hit$_source = hit._source) !== null && _hit$_source !== void 0 && (_hit$_source$user = _hit$_source.user) !== null && _hit$_source$user !== void 0 && _hit$_source$user.name)) {
    throw new Error('User name is missing');
  }
  if (!hit._id) {
    throw new Error('User ID is missing');
  }
  users[hit._source.user.name] = hit._id;
  return users;
}, {})).then(existingUsers => ({
  existingUsers,
  uploaded: batch
}));
exports.queryExistingUsers = queryExistingUsers;