"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEntitySnapshotIndex = createEntitySnapshotIndex;
exports.deleteAllEntitySnapshotIndices = deleteAllEntitySnapshotIndices;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createEntitySnapshotIndex({
  entityType,
  esClient,
  snapshotDate,
  namespace
}) {
  return esClient.indices.create({
    index: (0, _utils.getEntitiesSnapshotIndexName)(entityType, snapshotDate, namespace)
  }, {
    ignore: [409]
  });
}
async function deleteAllEntitySnapshotIndices({
  entityType,
  esClient,
  namespace
}) {
  const response = await esClient.indices.get({
    index: (0, _utils.getEntitiesSnapshotIndexPattern)(entityType, namespace),
    expand_wildcards: 'all'
  });
  const indexNames = Object.keys(response);
  const promises = indexNames.map(name => esClient.indices.delete({
    index: name,
    ignore_unavailable: true
  }, {
    ignore: [404]
  }));
  await Promise.all(promises);
}