"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suppressionDurationToSeconds = exports.sendAlertSuppressionTelemetryEvent = void 0;
var _events = require("../../../../telemetry/event_based/events");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suppressionDurationToSeconds = duration => {
  if (!duration) {
    return -1;
  }
  switch (duration.unit) {
    case 's':
      return duration.value;
    case 'm':
      return duration.value * 60;
    case 'h':
      return duration.value * 60 * 60;
    default:
      return -1;
  }
};
exports.suppressionDurationToSeconds = suppressionDurationToSeconds;
const sendAlertSuppressionTelemetryEvent = ({
  analytics,
  suppressedAlertsCount,
  createdAlertsCount,
  ruleParams,
  ruleAttributes
}) => {
  var _ruleParams$threshold, _ruleParams$threshold2, _ruleParams$threshold3;
  // do not send any telemetry event if suppression is not configured
  if (ruleParams.alertSuppression == null) {
    return;
  }

  // do not send any telemetry if no alerts were suppressed or created
  if (suppressedAlertsCount + createdAlertsCount === 0) {
    return;
  }
  const suppressionGroupByFieldsNumber = (0, _utils.isThresholdParams)(ruleParams) ? ((_ruleParams$threshold = ruleParams.threshold) === null || _ruleParams$threshold === void 0 ? void 0 : (_ruleParams$threshold2 = _ruleParams$threshold.field) === null || _ruleParams$threshold2 === void 0 ? void 0 : _ruleParams$threshold2.length) || 0 : ruleParams.alertSuppression.groupBy.length;
  const suppressionGroupByFields = (0, _utils.isThresholdParams)(ruleParams) ? ((_ruleParams$threshold3 = ruleParams.threshold) === null || _ruleParams$threshold3 === void 0 ? void 0 : _ruleParams$threshold3.field) || [] : ruleParams.alertSuppression.groupBy;
  const suppressionMissingFields = (0, _utils.isThresholdParams)(ruleParams) ? false : ruleParams.alertSuppression.missingFieldsStrategy !== 'doNotSuppress';
  const telemetryEvent = {
    suppressionAlertsCreated: createdAlertsCount,
    suppressionAlertsSuppressed: suppressedAlertsCount,
    suppressionRuleName: ruleParams.immutable ? ruleAttributes.name : 'Custom rule',
    suppressionDuration: suppressionDurationToSeconds(ruleParams.alertSuppression.duration),
    suppressionGroupByFieldsNumber,
    suppressionGroupByFields,
    suppressionRuleType: ruleParams.type,
    suppressionMissingFields,
    suppressionRuleId: ruleParams.ruleId
  };
  analytics.reportEvent(_events.ALERT_SUPPRESSION_EVENT.eventType, telemetryEvent);
};
exports.sendAlertSuppressionTelemetryEvent = sendAlertSuppressionTelemetryEvent;