"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListItemTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _inline_edit_list_item_value = require("./inline_edit_list_item_value");
var _delete_list_item = require("./delete_list_item");
var _formatted_date = require("../../common/components/formatted_date");
var _types = require("../types");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/value_list/components/list_item_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ListItemTable = ({
  canWriteIndex,
  items,
  pagination,
  sorting,
  loading,
  onChange,
  isError,
  list
}) => {
  const columns = [{
    field: _types.LIST_ITEM_FIELDS.value,
    name: _translations.COLUMN_VALUE,
    render: (value, item) => canWriteIndex ? /*#__PURE__*/_react.default.createElement(_inline_edit_list_item_value.InlineEditListItemValue, {
      listItem: item,
      key: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 25
      }
    }) : value,
    sortable: list.type !== 'text' && list.type !== 'ip_range'
  }, {
    field: _types.LIST_ITEM_FIELDS.updatedAt,
    name: _translations.COLUMN_UPDATED_AT,
    render: value => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
      value: value,
      fieldName: _types.LIST_ITEM_FIELDS.updatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }),
    width: '25%',
    sortable: true
  }, {
    field: _types.LIST_ITEM_FIELDS.updatedBy,
    name: _translations.COLUMN_UPDATED_BY,
    width: '15%'
  }];
  if (canWriteIndex) {
    columns.push({
      name: _translations.COLUMN_ACTIONS,
      actions: [{
        name: _translations.DELETE_LIST_ITEM,
        description: _translations.DELETE_LIST_ITEM_DESCRIPTION,
        isPrimary: true,
        render: item => /*#__PURE__*/_react.default.createElement(_delete_list_item.DeleteListItem, {
          id: item.id,
          value: item.value,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 45
          }
        })
      }],
      width: '10%'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "value-list-items-modal-table",
    items: items,
    columns: columns,
    pagination: pagination,
    sorting: sorting,
    error: isError ? _translations.FAILED_TO_FETCH_LIST_ITEM : undefined,
    loading: loading,
    onChange: onChange,
    noItemsMessage: _translations.NOT_FOUND_ITEMS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  });
};
exports.ListItemTable = ListItemTable;