"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationMessageCallout = exports.CALLOUT_TEST_ID = exports.ALERTS_ONLY_DATA_VIEW_BUTTON_TEST_ID = exports.ADD_ALERTS_FILTER_BUTTON_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_timeline_select_alerts_only_data_view = require("../hooks/use_timeline_select_alerts_only_data_view");
var _use_add_alerts_only_filter = require("../hooks/use_add_alerts_only_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/query/header/migration_message_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CALLOUT_TEST_ID = exports.CALLOUT_TEST_ID = 'timelineAlertsOnlyCallOut';
const ALERTS_ONLY_DATA_VIEW_BUTTON_TEST_ID = exports.ALERTS_ONLY_DATA_VIEW_BUTTON_TEST_ID = 'timelineAlertsOnlyDataViewButton';
const ADD_ALERTS_FILTER_BUTTON_TEST_ID = exports.ADD_ALERTS_FILTER_BUTTON_TEST_ID = 'timelineAddAlertsFitlerButton';
/**
 * Callout message displayed in timelines to inform users that with the new data view picker
 * we don't support the "show detection alerts only" option we had with sourcerer.
 * So their option is to either swithc to use the alerts data view
 * or use the default data view and add an alerts-only filter.
 */
const MigrationMessageCallout = exports.MigrationMessageCallout = /*#__PURE__*/(0, _react.memo)(({
  timelineId
}) => {
  const selectAlertsDataView = (0, _use_timeline_select_alerts_only_data_view.useTimelineSelectAlertsOnlyDataView)();
  const addAlertsFilter = (0, _use_add_alerts_only_filter.useAddAlertsOnlyFilter)({
    timelineId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    color: "warning",
    "data-test-subj": CALLOUT_TEST_ID,
    iconType: "warning",
    size: "m",
    title: i18n.CALL_OUT_ALERTS_ONLY_MIGRATION_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, i18n.CALL_OUT_ALERTS_ONLY_MIGRATION_CONTENT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": i18n.CALL_OUT_ALERTS_ONLY_MIGRATION_SWITCH_BUTTON,
    color: "text",
    "data-test-subj": ALERTS_ONLY_DATA_VIEW_BUTTON_TEST_ID,
    onClick: selectAlertsDataView,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }, i18n.CALL_OUT_ALERTS_ONLY_MIGRATION_SWITCH_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": i18n.CALL_OUT_FILTER_FOR_ALERTS_BUTTON,
    color: "warning",
    "data-test-subj": ADD_ALERTS_FILTER_BUTTON_TEST_ID,
    fill: true,
    onClick: addAlertsFilter,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, i18n.CALL_OUT_FILTER_FOR_ALERTS_BUTTON))))));
});
MigrationMessageCallout.displayName = 'MigrationMessageCallout';