"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourcererDataView = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _store = require("../store");
var _model = require("../store/model");
var _helpers = require("../store/helpers");
var _use_data_view = require("../../common/containers/source/use_data_view");
var _source = require("../../common/containers/source");
var _sourcerer = require("../../../common/utils/sourcerer");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSourcererDataView = (scopeId = _model.SourcererScopeName.default) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const kibanaDataViews = (0, _reactRedux.useSelector)(_store.sourcererSelectors.kibanaDataViews);
  const signalIndexName = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const selectedDataViewId = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedDataViewId(state, scopeId);
  });
  const selectedDataView = (0, _react.useMemo)(() => {
    return kibanaDataViews.find(dataView => dataView.id === selectedDataViewId);
  }, [kibanaDataViews, selectedDataViewId]);
  const loading = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeIsLoading(state, scopeId);
  });
  const scopeSelectedPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedPatterns(state, scopeId);
  });
  const missingPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeMissingPatterns(state, scopeId);
  });
  const selectedPatterns = (0, _react.useMemo)(() => (0, _sourcerer.sortWithExcludesAtEnd)(scopeSelectedPatterns), [scopeSelectedPatterns]);
  const [legacyPatterns, setLegacyPatterns] = (0, _react.useState)([]);
  const [indexPatternsLoading, fetchIndexReturn] = (0, _source.useFetchIndex)(legacyPatterns);
  const legacyDataView = (0, _react.useMemo)(() => {
    var _ref, _fetchIndexReturn$dat, _fetchIndexReturn$dat2, _fetchIndexReturn$dat3, _fetchIndexReturn$dat4, _fetchIndexReturn$dat5, _fetchIndexReturn$dat6;
    return {
      ...fetchIndexReturn,
      dataView: fetchIndexReturn.dataView,
      runtimeMappings: (_ref = (_fetchIndexReturn$dat = fetchIndexReturn.dataView) === null || _fetchIndexReturn$dat === void 0 ? void 0 : _fetchIndexReturn$dat.runtimeFieldMap) !== null && _ref !== void 0 ? _ref : {},
      title: (_fetchIndexReturn$dat2 = (_fetchIndexReturn$dat3 = fetchIndexReturn.dataView) === null || _fetchIndexReturn$dat3 === void 0 ? void 0 : _fetchIndexReturn$dat3.title) !== null && _fetchIndexReturn$dat2 !== void 0 ? _fetchIndexReturn$dat2 : '',
      id: (_fetchIndexReturn$dat4 = (_fetchIndexReturn$dat5 = fetchIndexReturn.dataView) === null || _fetchIndexReturn$dat5 === void 0 ? void 0 : _fetchIndexReturn$dat5.id) !== null && _fetchIndexReturn$dat4 !== void 0 ? _fetchIndexReturn$dat4 : null,
      loading: indexPatternsLoading,
      patternList: fetchIndexReturn.indexes,
      indexFields: fetchIndexReturn.indexPatterns.fields,
      fields: (_fetchIndexReturn$dat6 = fetchIndexReturn.dataView) === null || _fetchIndexReturn$dat6 === void 0 ? void 0 : _fetchIndexReturn$dat6.fields
    };
  }, [fetchIndexReturn, indexPatternsLoading]);
  (0, _react.useEffect)(() => {
    if (newDataViewPickerEnabled) {
      return;
    }
    if (selectedDataView == null || missingPatterns.length > 0) {
      // old way of fetching indices, legacy timeline
      setLegacyPatterns(selectedPatterns);
    } else if (legacyPatterns.length > 0) {
      // Only create a new array reference if legacyPatterns is not empty
      setLegacyPatterns([]);
    }
  }, [legacyPatterns.length, newDataViewPickerEnabled, missingPatterns, selectedDataView, selectedPatterns]);
  const sourcererDataView = (0, _react.useMemo)(() => {
    const _dv = selectedDataView == null || missingPatterns.length > 0 ? legacyDataView : selectedDataView;
    // Make sure the title is up to date, so that the correct index patterns are used everywhere
    return {
      ..._dv,
      dataView: {
        ..._dv.dataView,
        title: selectedPatterns.join(','),
        name: selectedPatterns.join(',')
      }
    };
  }, [legacyDataView, missingPatterns.length, selectedDataView, selectedPatterns]);
  const indicesExist = (0, _react.useMemo)(() => {
    if (loading || sourcererDataView.loading) {
      return true;
    } else {
      return (0, _helpers.checkIfIndicesExist)({
        scopeId,
        signalIndexName,
        patternList: sourcererDataView.patternList,
        isDefaultDataViewSelected: sourcererDataView.id === defaultDataView.id
      });
    }
  }, [defaultDataView.id, loading, scopeId, signalIndexName, sourcererDataView.id, sourcererDataView.loading, sourcererDataView.patternList]);
  const browserFields = (0, _react.useCallback)(() => {
    const {
      browserFields: dataViewBrowserFields
    } = (0, _use_data_view.getDataViewStateFromIndexFields)(sourcererDataView.patternList.join(','), sourcererDataView.fields);
    return dataViewBrowserFields;
  }, [sourcererDataView.fields, sourcererDataView.patternList]);
  return (0, _react.useMemo)(() => ({
    browserFields: browserFields(),
    dataViewId: sourcererDataView.id,
    indicesExist,
    loading: loading || sourcererDataView.loading,
    // selected patterns in DATA_VIEW including filter
    selectedPatterns,
    sourcererDataView: sourcererDataView.dataView
  }), [browserFields, sourcererDataView, selectedPatterns, indicesExist, loading]);
};
exports.useSourcererDataView = useSourcererDataView;