"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePickIndexPatterns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _helpers = require("../store/helpers");
var _store = require("../store");
var _helpers2 = require("./helpers");
var _model = require("../store/model");
var _sourcerer = require("../../../common/utils/sourcerer");
var _kibana = require("../../common/lib/kibana");
var _get_sourcerer_data_view = require("../containers/get_sourcerer_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/use_pick_index_patterns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const patternListToOptions = (patternList, selectablePatterns) => (0, _sourcerer.sortWithExcludesAtEnd)(patternList).map(s => ({
  label: s,
  value: s,
  ...(selectablePatterns != null ? {
    disabled: !selectablePatterns.includes(s)
  } : {})
}));
const usePickIndexPatterns = ({
  dataViewId,
  defaultDataViewId,
  isOnlyDetectionAlerts,
  kibanaDataViews,
  missingPatterns,
  scopeId,
  selectedDataViewId,
  selectedPatterns,
  signalIndexName
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: {
      dataViews
    }
  } = (0, _kibana.useKibana)().services;
  const isHookAlive = (0, _react.useRef)(true);
  const [loadingIndexPatterns, setLoadingIndexPatterns] = (0, _react.useState)(false);
  // anything that uses patternListToOptions should be memoized, as it always returns a new array
  // TODO: fix that
  const signalPatternListToOptions = (0, _react.useMemo)(() => {
    return signalIndexName ? patternListToOptions([signalIndexName]) : [];
  }, [signalIndexName]);
  const selectedPatternsAsOptions = (0, _react.useMemo)(() => {
    return patternListToOptions(selectedPatterns);
  }, [selectedPatterns]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)(isOnlyDetectionAlerts ? signalPatternListToOptions : selectedPatternsAsOptions);
  const [isModified, setIsModified] = (0, _react.useState)(dataViewId == null ? 'deprecated' : missingPatterns.length > 0 ? 'missingPatterns' : '');
  const {
    allPatterns,
    selectablePatterns
  } = (0, _react.useMemo)(() => {
    if (isOnlyDetectionAlerts && signalIndexName) {
      return {
        allPatterns: [signalIndexName],
        selectablePatterns: [signalIndexName]
      };
    }
    const theDataView = kibanaDataViews.find(dataView => dataView.id === dataViewId);
    if (theDataView == null) {
      return {
        allPatterns: [],
        selectablePatterns: []
      };
    }
    const titleAsList = [...new Set(theDataView.title.split(','))];
    return scopeId === _store.sourcererModel.SourcererScopeName.default ? {
      allPatterns: (0, _helpers2.getPatternListWithoutSignals)(titleAsList, signalIndexName),
      selectablePatterns: (0, _helpers2.getPatternListWithoutSignals)(theDataView.patternList, signalIndexName)
    } : {
      allPatterns: titleAsList,
      selectablePatterns: theDataView.patternList
    };
  }, [dataViewId, isOnlyDetectionAlerts, kibanaDataViews, scopeId, signalIndexName]);
  const allOptions = (0, _react.useMemo)(() => patternListToOptions(allPatterns, selectablePatterns), [allPatterns, selectablePatterns]);
  const getDefaultSelectedOptionsByDataView = (0, _react.useCallback)((id, isAlerts = false) => scopeId === _model.SourcererScopeName.detections || isAlerts ? signalPatternListToOptions : patternListToOptions((0, _helpers.getScopePatternListSelection)(kibanaDataViews.find(dataView => dataView.id === id), scopeId, signalIndexName, id === defaultDataViewId)), [signalPatternListToOptions, kibanaDataViews, scopeId, signalIndexName, defaultDataViewId]);
  const defaultSelectedPatternsAsOptions = (0, _react.useMemo)(() => dataViewId != null ? getDefaultSelectedOptionsByDataView(dataViewId) : [], [dataViewId, getDefaultSelectedOptionsByDataView]);
  const onSetIsModified = (0, _react.useCallback)((patterns, id) => {
    if (id == null) {
      return setIsModified('deprecated');
    }
    if (missingPatterns.length > 0) {
      return setIsModified('missingPatterns');
    }
    if (isOnlyDetectionAlerts) {
      return setIsModified('alerts');
    }
    const isPatternsModified = defaultSelectedPatternsAsOptions.length !== patterns.length || !defaultSelectedPatternsAsOptions.every(option => patterns.find(pattern => option.value === pattern));
    return setIsModified(isPatternsModified ? 'modified' : '');
  }, [defaultSelectedPatternsAsOptions, isOnlyDetectionAlerts, missingPatterns.length]);
  (0, _react.useEffect)(() => {
    setSelectedOptions(scopeId === _model.SourcererScopeName.detections ? signalPatternListToOptions : selectedPatternsAsOptions);
  }, [selectedPatterns, scopeId, selectedPatternsAsOptions, signalPatternListToOptions]);
  // when scope updates, check modified to set/remove alerts label
  (0, _react.useEffect)(() => {
    onSetIsModified(selectedPatterns.map(pattern => pattern), selectedDataViewId);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isOnlyDetectionAlerts, selectedDataViewId, missingPatterns, scopeId, selectedPatterns]);
  const onChangeCombo = (0, _react.useCallback)(newSelectedOptions => {
    setSelectedOptions(newSelectedOptions);
  }, []);
  const renderOption = (0, _react.useCallback)(({
    value
  }) => /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-combo-option",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 20
    }
  }, value), []);
  const setIndexPatternsByDataView = (0, _react.useCallback)(async (newSelectedDataViewId, isAlerts) => {
    if (kibanaDataViews.some(kdv => kdv.id === newSelectedDataViewId && Object.keys((kdv === null || kdv === void 0 ? void 0 : kdv.fields) || {}).length === 0)) {
      try {
        setLoadingIndexPatterns(true);
        setSelectedOptions([]);
        const dataView = await (0, _get_sourcerer_data_view.getSourcererDataView)(newSelectedDataViewId, dataViews);
        if (isHookAlive.current) {
          dispatch(_store.sourcererActions.setDataView(dataView));
          setSelectedOptions(isOnlyDetectionAlerts ? signalPatternListToOptions : patternListToOptions(dataView.patternList));
        }
      } catch (err) {
        // Nothing to do
      }
      setLoadingIndexPatterns(false);
    } else {
      setSelectedOptions(getDefaultSelectedOptionsByDataView(newSelectedDataViewId, isAlerts));
    }
  }, [signalPatternListToOptions, dispatch, getDefaultSelectedOptionsByDataView, isOnlyDetectionAlerts, kibanaDataViews, dataViews]);
  const dataViewSelectOptions = (0, _react.useMemo)(() => dataViewId != null ? (0, _helpers2.getDataViewSelectOptions)({
    dataViewId,
    defaultDataViewId,
    isModified: isModified === 'modified',
    isOnlyDetectionAlerts,
    kibanaDataViews
  }) : [], [dataViewId, defaultDataViewId, isModified, isOnlyDetectionAlerts, kibanaDataViews]);
  (0, _react.useEffect)(() => {
    isHookAlive.current = true;
    return () => {
      isHookAlive.current = false;
    };
  }, []);
  const handleOutsideClick = (0, _react.useCallback)(() => {
    setSelectedOptions(selectedPatternsAsOptions);
  }, [selectedPatternsAsOptions]);
  return {
    allOptions,
    dataViewSelectOptions,
    loadingIndexPatterns,
    handleOutsideClick,
    isModified,
    onChangeCombo,
    renderOption,
    selectedOptions,
    setIndexPatternsByDataView
  };
};
exports.usePickIndexPatterns = usePickIndexPatterns;