"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateGetMigrationPrivileges = exports.useGetMigrationMissingPrivileges = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _constants = require("../../../../common/siem_migrations/constants");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../api");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetMigrationMissingPrivileges = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['GET', _constants.SIEM_RULE_MIGRATION_MISSING_PRIVILEGES_PATH], async ({
    signal
  }) => (0, _api.getRuleMigrationMissingPrivileges)({
    signal
  }), {
    ..._constants2.DEFAULT_QUERY_OPTIONS,
    onError: error => {
      addError(error, {
        title: i18n.GET_MIGRATION_RULES_FAILURE
      });
    }
  });
};

/**
 * We should use this hook to invalidate the migration privileges cache.
 * @returns A migration privileges cache invalidation callback
 */
exports.useGetMigrationMissingPrivileges = useGetMigrationMissingPrivileges;
const useInvalidateGetMigrationPrivileges = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(['GET', _constants.SIEM_RULE_MIGRATION_MISSING_PRIVILEGES_PATH], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateGetMigrationPrivileges = useInvalidateGetMigrationPrivileges;