"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemTranslatedRulesTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_is_element_mounted = require("../../../../../detection_engine/rule_management_ui/components/rules_table/rules_table/guided_onboarding/use_is_element_mounted");
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _step_config = require("./step_config");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/tours/translation_guide/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SiemTranslatedRulesTour = exports.SiemTranslatedRulesTour = /*#__PURE__*/_react.default.memo(() => {
  const {
    siemMigrations,
    storage
  } = (0, _kibana.useKibana)().services;
  const stepsCount = Object.keys(_step_config.tourSteps).length;
  const selectMigrationStepData = _step_config.tourSteps[_step_config.TourSteps.MIGRATION_SELECTION];
  const statusHeaderStepData = _step_config.tourSteps[_step_config.TourSteps.MIGRATION_RULE_STATUS];
  const getStartedStepData = _step_config.tourSteps[_step_config.TourSteps.MIGRATION_ONBOARDING_HUB];
  const isSelectMigrationAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(selectMigrationStepData.anchorId);
  const isStatusHeaderAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(statusHeaderStepData.anchorId);
  const isGetStartedNavigationAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(getStartedStepData.anchorId);
  const [tourState, setTourState] = (0, _react.useState)(() => {
    const restoredTourState = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.SIEM_RULE_TRANSLATION_PAGE);
    if (restoredTourState != null) {
      return restoredTourState;
    }
    return _step_config.tourConfig;
  });
  const onTourFinished = (0, _react.useCallback)(() => {
    setTourState({
      ...tourState,
      isTourActive: false
    });
  }, [tourState]);
  const onTourNext = (0, _react.useCallback)(() => {
    setTourState({
      ...tourState,
      currentTourStep: tourState.currentTourStep + 1
    });
  }, [tourState]);
  (0, _react.useEffect)(() => {
    storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.SIEM_RULE_TRANSLATION_PAGE, tourState);
  }, [tourState, storage]);
  const isTourActive = (0, _react.useMemo)(() => {
    return siemMigrations.rules.isAvailable() && tourState.isTourActive;
  }, [siemMigrations.rules, tourState]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSelectMigrationAnchorMounted && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: selectMigrationStepData.title,
    content: selectMigrationStepData.content,
    onFinish: _lodash.noop,
    step: selectMigrationStepData.step,
    stepsTotal: stepsCount,
    isStepOpen: isTourActive && tourState.currentTourStep === selectMigrationStepData.step,
    anchor: `#${selectMigrationStepData.anchorId}`,
    anchorPosition: selectMigrationStepData.anchorPosition,
    maxWidth: tourState.tourPopoverWidth,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.NEXT_TOUR_STEP_BUTTON,
      size: "xs",
      color: "text",
      flush: "right",
      onClick: onTourNext,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, i18n.NEXT_TOUR_STEP_BUTTON),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }), isStatusHeaderAnchorMounted && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: statusHeaderStepData.title,
    content: statusHeaderStepData.content,
    onFinish: _lodash.noop,
    step: statusHeaderStepData.step,
    stepsTotal: stepsCount,
    isStepOpen: isTourActive && tourState.currentTourStep === statusHeaderStepData.step,
    anchor: `#${statusHeaderStepData.anchorId}`,
    anchorPosition: statusHeaderStepData.anchorPosition,
    maxWidth: tourState.tourPopoverWidth,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.NEXT_TOUR_STEP_BUTTON,
      size: "xs",
      color: "text",
      flush: "right",
      onClick: onTourNext,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, i18n.NEXT_TOUR_STEP_BUTTON),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), isGetStartedNavigationAnchorMounted && /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: getStartedStepData.title,
    content: getStartedStepData.content,
    onFinish: _lodash.noop,
    step: getStartedStepData.step,
    stepsTotal: stepsCount,
    isStepOpen: isTourActive && tourState.currentTourStep === getStartedStepData.step,
    anchor: `#${getStartedStepData.anchorId}`,
    anchorPosition: getStartedStepData.anchorPosition,
    maxWidth: tourState.tourPopoverWidth,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.FINISH_TOUR_BUTTON,
      size: "xs",
      color: "text",
      flush: "right",
      onClick: onTourFinished,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }, i18n.FINISH_TOUR_BUTTON),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }));
});
SiemTranslatedRulesTour.displayName = 'SiemTranslatedRulesTour';