"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MacrosDataInputSubSteps = exports.MacrosDataInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _migration_steps = require("../../../../../common/components/migration_steps");
var _get_eui_step_status = require("../../../../../common/utils/get_eui_step_status");
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
var _copy_export_query = require("./sub_steps/copy_export_query");
var _macros_file_upload = require("./sub_steps/macros_file_upload");
var _check_resources = require("../common/check_resources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/steps/macros/macros_data_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MacrosDataInput = exports.MacrosDataInput = /*#__PURE__*/_react.default.memo(({
  dataInputStep,
  migrationStats,
  missingMacros,
  onMissingResourcesFetched
}) => {
  const dataInputStatus = (0, _react.useMemo)(() => (0, _get_eui_step_status.getEuiStepStatus)(_constants.DashboardUploadSteps.MacrosUpload, dataInputStep), [dataInputStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepNumber, {
    "data-test-subj": "macrosUploadStepNumber",
    titleSize: "xs",
    number: _constants.DashboardUploadSteps.MacrosUpload,
    status: dataInputStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "macrosUploadTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 19
    }
  }, i18n.MACROS_DATA_INPUT_TITLE))))), dataInputStatus === 'current' && migrationStats && missingMacros && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(MacrosDataInputSubSteps, {
    migrationStats: migrationStats,
    missingMacros: missingMacros,
    onMissingResourcesFetched: onMissingResourcesFetched,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }))));
});
MacrosDataInput.displayName = 'MacrosDataInput';
const END = 10;
const MacrosDataInputSubSteps = exports.MacrosDataInputSubSteps = /*#__PURE__*/_react.default.memo(({
  migrationStats,
  missingMacros,
  onMissingResourcesFetched
}) => {
  const [subStep, setSubStep] = (0, _react.useState)(missingMacros.length ? 1 : 3);
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services.siemMigrations.dashboards;

  // Copy query step
  const onCopied = (0, _react.useCallback)(() => {
    setSubStep(2);
    telemetry.reportSetupMacrosQueryCopied({
      migrationId: migrationStats.id
    });
  }, [telemetry, migrationStats.id]);
  const copyStep = (0, _copy_export_query.useCopyExportQueryStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(1, subStep),
    onCopied
  });

  // Upload macros step
  const onMacrosCreatedStep = (0, _react.useCallback)(() => {
    setSubStep(3);
  }, []);
  const uploadStep = (0, _macros_file_upload.useMacrosFileUploadStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(2, subStep),
    migrationStats,
    missingMacros,
    onMacrosCreated: onMacrosCreatedStep
  });

  // Check missing resources step
  const onMissingResourcesFetchedStep = (0, _react.useCallback)(newMissingResources => {
    onMissingResourcesFetched(newMissingResources);
    setSubStep(END);
  }, [onMissingResourcesFetched]);
  const resourcesStep = (0, _check_resources.useCheckResourcesStep)({
    status: (0, _get_eui_step_status.getEuiStepStatus)(3, subStep),
    migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetchedStep
  });
  const steps = (0, _react.useMemo)(() => [copyStep, uploadStep, resourcesStep], [copyStep, uploadStep, resourcesStep]);
  return /*#__PURE__*/_react.default.createElement(_migration_steps.SubSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 12
    }
  });
});
MacrosDataInputSubSteps.displayName = 'MacrosDataInputActive';