"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryTabBase = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _userProfileComponents = require("@kbn/user-profile-components");
var _use_bulk_get_user_profiles = require("../../../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var _test_ids = require("../../../../../../common/components/user_profiles/test_ids");
var _constants = require("../../../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/details_flyout/tabs/summary/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SummaryTabBase = exports.SummaryTabBase = /*#__PURE__*/_react.default.memo(function SummaryTabBase({
  comments,
  getEventDetails
}) {
  const userProfileIds = (0, _react.useMemo)(() => {
    if (!comments) {
      return new Set();
    }
    return comments.reduce((acc, {
      created_by: createdBy
    }) => {
      if (createdBy !== _constants.SIEM_MIGRATIONS_ASSISTANT_USER) acc.add(createdBy);
      return acc;
    }, new Set());
  }, [comments]);
  const {
    isLoading: isLoadingUserProfiles,
    data: userProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: userProfileIds
  });
  const euiComments = (0, _react.useMemo)(() => {
    if (isLoadingUserProfiles) {
      return undefined;
    }
    return comments === null || comments === void 0 ? void 0 : comments.map(comment => {
      var _profile$user$full_na;
      const {
        message,
        created_at: createdAt,
        created_by: createdBy
      } = comment;
      const profile = userProfiles === null || userProfiles === void 0 ? void 0 : userProfiles.find(({
        uid
      }) => uid === createdBy);
      const isCreatedByAssistant = createdBy === _constants.SIEM_MIGRATIONS_ASSISTANT_USER || !profile;
      const username = isCreatedByAssistant ? i18n.ASSISTANT_USERNAME : (_profile$user$full_na = profile.user.full_name) !== null && _profile$user$full_na !== void 0 ? _profile$user$full_na : profile.user.username;
      return {
        username,
        timelineAvatarAriaLabel: username,
        timelineAvatar: isCreatedByAssistant ? /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantAvatar, {
          name: "machine",
          size: "l",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 11
          }
        }) : /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
          "data-test-subj": (0, _test_ids.USER_AVATAR_ITEM_TEST_ID)(username),
          user: profile === null || profile === void 0 ? void 0 : profile.user,
          avatar: profile === null || profile === void 0 ? void 0 : profile.data.avatar,
          size: 'l',
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 11
          }
        }),
        event: getEventDetails(comment),
        timestamp: (0, _moment.default)(createdAt).format('ll'),
        // Date formats https://momentjs.com/docs/#/displaying/format/
        children: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
          textSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 19
          }
        }, message)
      };
    });
  }, [isLoadingUserProfiles, comments, userProfiles, getEventDetails]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    comments: euiComments,
    "aria-label": i18n.ASSISTANT_COMMENTS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }));
});