"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColors = useColors;
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get access to Kibana-theme based colors.
 */
function useColors() {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const darkMode = (0, _react.useMemo)(() => colorMode === 'DARK', [colorMode]);
  return (0, _react.useMemo)(() => ({
    descriptionText: euiTheme.colors.textParagraph,
    full: euiTheme.colors.fullShade,
    graphControls: euiTheme.colors.darkestShade,
    graphControlsBackground: euiTheme.colors.emptyShade,
    graphControlsBorderColor: euiTheme.colors.lightShade,
    processBackingFill: `${euiTheme.colors.primary}${darkMode ? '1F' : '0F'}`,
    // Add opacity 0F = 6% , 1F = 12%
    resolverBackground: euiTheme.colors.emptyShade,
    resolverEdge: darkMode ? euiTheme.colors.lightShade : euiTheme.colors.lightestShade,
    resolverBreadcrumbBackground: euiTheme.colors.lightestShade,
    resolverEdgeText: darkMode ? euiTheme.colors.fullShade : euiTheme.colors.darkShade,
    triggerBackingFill: `${euiTheme.colors.danger}${darkMode ? '1F' : '0F'}`,
    pillStroke: euiTheme.colors.lightShade
  }), [darkMode, euiTheme]);
}